/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.xppm.unittest.MockElement;

public class TriggerElement
implements MockElement {
    private static Logger logger = Logger.getLogger((String)TriggerElement.class.getName());
    private String filename;
    private String content;

    public TriggerElement(String filename, String content) throws IOException {
        this.filename = filename;
        this.content = content;
        this.writeContent(content);
    }

    public TriggerElement(String filename) throws IOException {
        this.filename = filename;
        this.content = this.readContent();
    }

    public boolean equals(Object tmpo) {
        if (tmpo == null || !(tmpo instanceof TriggerElement)) {
            return false;
        }
        TriggerElement tElement = (TriggerElement)tmpo;
        return this.filename.equals(tElement.filename) && this.content.endsWith(tElement.content);
    }

    public String getXMLElement() {
        StringBuffer buff = new StringBuffer("<trigger file=\"");
        buff.append(this.filename).append("\"/>");
        return buff.toString();
    }

    public String getContent() {
        return this.content;
    }

    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeContent(String content) throws IOException {
        writer = null;
        try {
            writer = new PrintWriter(new File(this.filename));
            writer.print(content);
            var4_3 = null;
            ** if (writer == null) goto lbl-1000
        }
        catch (Throwable var3_7) {
            var4_4 = null;
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    TriggerElement.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            throw var3_7;
        }
lbl-1000:
        // 1 sources

        {
            try {
                writer.close();
            }
            catch (Exception ex) {
                TriggerElement.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        TriggerElement.logger.debug((Object)("Written trigger file: " + this.filename + " with " + content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String readContent() throws IOException {
        reader = null;
        buff = new StringBuffer();
        try {
            reader = new BufferedReader(new FileReader(this.filename));
            tmps = reader.readLine();
            while (tmps != null) {
                buff.append(tmps).append(System.getProperty("line.separator"));
                tmps = reader.readLine();
            }
            var5_4 = null;
            ** if (reader == null) goto lbl-1000
        }
        catch (Throwable var4_8) {
            var5_5 = null;
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    TriggerElement.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            throw var4_8;
        }
lbl-1000:
        // 1 sources

        {
            try {
                reader.close();
            }
            catch (Exception ex) {
                TriggerElement.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        tmps = buff.toString().trim();
        TriggerElement.logger.debug((Object)("Read " + tmps + " from trigger file: " + this.filename));
        return tmps;
    }
}

