/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import java.io.File;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.xppm.ConfigurationEvent;
import org.glite.ce.commonj.configuration.xppm.ConfigurationListener;
import org.glite.ce.commonj.configuration.xppm.ConfigurationManager;
import org.glite.ce.commonj.configuration.xppm.unittest.ConfigFile;
import org.glite.ce.commonj.configuration.xppm.unittest.FailureElement;
import org.glite.ce.commonj.configuration.xppm.unittest.GenericConfigListener;
import org.glite.ce.commonj.configuration.xppm.unittest.LogUtils;
import org.glite.ce.commonj.configuration.xppm.unittest.MockElement;
import org.glite.ce.commonj.configuration.xppm.unittest.SimpleElement;
import org.glite.ce.commonj.configuration.xppm.unittest.TLAttributes;
import org.glite.ce.commonj.configuration.xppm.unittest.TriggerElement;

public class TestTriggerManager
extends TestCase {
    private static Logger logger = Logger.getLogger((String)TestTriggerManager.class.getName());
    private ConfigFile confFile = new ConfigFile();
    private String triggerFile1 = this.confFile.getDirectory() + File.separator + "trigger1.txt";

    public TestTriggerManager(String name) {
        super(name);
        LogUtils.setup();
    }

    protected void setUp() throws Exception {
        TLAttributes attributes = new TLAttributes("id-value", "code-value");
        MockElement[] elements = new MockElement[]{new SimpleElement("myattr", "mycontent"), new TriggerElement(this.triggerFile1, "trigger content")};
        this.confFile.write(attributes, elements, false);
    }

    protected void tearDown() {
        this.confFile.delete();
    }

    public void testTriggerOnReloading() throws Exception {
        String contentStr = "new trigger content";
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename());
        Object[] tmpo = cMan.getConfigurationElements(TriggerElement.class);
        Thread.sleep(2000L);
        new TriggerElement(this.triggerFile1, contentStr);
        Thread.sleep(12000L);
        tmpo = cMan.getConfigurationElements(TriggerElement.class);
        if (tmpo.length == 0) {
            TestTriggerManager.fail((String)"Missing trigger element");
            return;
        }
        TriggerElement resElem = (TriggerElement)tmpo[0];
        String resContent = resElem.getContent();
        TestTriggerManager.assertTrue((boolean)resContent.equals(contentStr));
    }

    public void testTriggerAndAttributeReloading() throws Exception {
        String contentStr = "new trigger content";
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename());
        Object[] tmpo = cMan.getConfigurationElements(TriggerElement.class);
        Thread.sleep(2000L);
        TLAttributes attributes = new TLAttributes("new-id-value", "new-code-value");
        MockElement[] elements = new MockElement[]{new SimpleElement("myattr", "mycontent"), new TriggerElement(this.triggerFile1, contentStr)};
        this.confFile.write(attributes, elements, false);
        Thread.sleep(12000L);
        tmpo = cMan.getConfigurationElements(TriggerElement.class);
        if (tmpo.length == 0) {
            TestTriggerManager.fail((String)"Missing trigger element");
            return;
        }
        TriggerElement resElem = (TriggerElement)tmpo[0];
        String resContent = resElem.getContent();
        tmpo = cMan.getConfigurationElements(TLAttributes.class);
        if (tmpo.length == 0) {
            TestTriggerManager.fail((String)"Missing attribute id");
            return;
        }
        TLAttributes attrs = (TLAttributes)tmpo[0];
        TestTriggerManager.assertTrue((resContent.equals(contentStr) && attrs.id.equals("new-id-value") ? 1 : 0) != 0);
    }

    public void testTriggerOnRollBack() throws Exception {
        String contentStr = "new trigger content";
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename());
        Object[] tmpo = cMan.getConfigurationElements(TriggerElement.class);
        Thread.sleep(2000L);
        TLAttributes attributes = new TLAttributes("id-value", "code-value");
        MockElement[] elements = new MockElement[]{new TriggerElement(this.triggerFile1, contentStr), new FailureElement(true, "failure content")};
        this.confFile.write(attributes, elements, false);
        Thread.sleep(12000L);
        tmpo = cMan.getConfigurationElements(TriggerElement.class);
        if (tmpo.length == 0) {
            TestTriggerManager.fail((String)"Missing trigger element");
            return;
        }
        TriggerElement resElem = (TriggerElement)tmpo[0];
        String resContent = resElem.getContent();
        TestTriggerManager.assertFalse((boolean)resContent.equals(contentStr));
    }

    public void testNotificationFromTrigger() throws Exception {
        String contentStr = "new trigger content";
        GenericConfigListener listener = new GenericConfigListener();
        ConfigurationListener[] lsnrs = new ConfigurationListener[]{listener};
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename(), 10000L, lsnrs);
        Object[] tmpo = cMan.getConfigurationElements(TriggerElement.class);
        Thread.sleep(1000L);
        new TriggerElement(this.triggerFile1, contentStr);
        Thread.sleep(12000L);
        tmpo = cMan.getConfigurationElements(TriggerElement.class);
        if (tmpo.length == 0) {
            TestTriggerManager.fail((String)"Missing trigger element");
            return;
        }
        Thread.sleep(1000L);
        ConfigurationEvent lastEvn = listener.getLastEvent();
        logger.debug((Object)("Last event category " + lastEvn.getCategory().getName()));
        boolean result = lastEvn != null;
        result &= lastEvn.getCategory() == TriggerElement.class;
        TestTriggerManager.assertTrue((boolean)(result &= lastEvn.getType() == 1));
    }
}

