/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import java.io.File;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.glite.ce.commonj.configuration.xppm.unittest.SimpleElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleElementConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)SimpleElementConfigHandler.class.getName());
    private static final String XPATH_STRING = "/service/simple";
    private XPathExpression expr;
    private SimpleElement[] currElements;
    private SimpleElement[] tmpElements;

    public SimpleElementConfigHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
        this.currElements = null;
        this.tmpElements = null;
    }

    public XPathExpression getXPath() {
        return this.expr;
    }

    public Class<?> getCategory() {
        return SimpleElement.class;
    }

    public Object[] getConfigurationElement() {
        return this.currElements;
    }

    public boolean process(NodeList parsedElements) {
        ArrayList<SimpleElement> tmpList = new ArrayList<SimpleElement>();
        for (int k = 0; k < parsedElements.getLength(); ++k) {
            Element sElem = (Element)parsedElements.item(k);
            SimpleElement item = new SimpleElement(sElem.getAttribute("attribute"), sElem.getTextContent());
            logger.debug((Object)("Found element " + item.content));
            tmpList.add(item);
        }
        this.tmpElements = new SimpleElement[tmpList.size()];
        tmpList.toArray(this.tmpElements);
        boolean result = this.tmpElements != this.currElements;
        logger.debug((Object)("Commit SimpleElement list: " + result));
        return result;
    }

    public boolean processTriggers() {
        return false;
    }

    public void commit() {
        this.currElements = this.tmpElements;
        this.tmpElements = null;
    }

    public void rollback() {
        this.tmpElements = null;
    }

    public File[] getTriggers() {
        return null;
    }

    public void clean() {
    }
}

