/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.xppm.unittest.MockElement;
import org.glite.ce.commonj.configuration.xppm.unittest.TLAttributes;

public class ConfigFile {
    private static Logger logger = Logger.getLogger((String)ConfigFile.class.getName());
    private String confFilename = System.getProperty("xml.test.config.file", "myconfig.xml");

    public void write(TLAttributes topLevelAttrs, MockElement[] elements, boolean simulateError) throws IOException {
        logger.debug((Object)("Writing config file " + this.confFilename));
        PrintWriter writer = new PrintWriter(new File(this.confFilename));
        writer.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        writer.print("<service name=\"testservice\" ");
        writer.print(topLevelAttrs.getXMLAttributes());
        writer.println(">");
        for (MockElement elem : elements) {
            writer.println(elem.getXMLElement());
        }
        if (!simulateError) {
            writer.println("</service>");
        }
        writer.flush();
        writer.close();
    }

    public void delete() {
        File tmpf = new File(this.confFilename);
        tmpf.delete();
    }

    public String getFilename() {
        return this.confFilename;
    }

    public String getDirectory() {
        return new File(this.confFilename).getParent();
    }
}

