/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.utils;

import java.util.Calendar;
import org.glite.ce.commonj.utils.TaskQueue;
import org.glite.ce.commonj.utils.TimerTask;

class TimerThread
extends Thread {
    boolean newTasksMayBeScheduled = true;
    private TaskQueue queue;

    TimerThread(TaskQueue queue) {
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TaskQueue taskQueue;
        try {
            this.mainLoop();
            Object var2_1 = null;
            taskQueue = this.queue;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            TaskQueue taskQueue2 = this.queue;
            synchronized (taskQueue2) {
                this.newTasksMayBeScheduled = false;
                this.queue.clear();
            }
            throw throwable;
        }
        synchronized (taskQueue) {
            this.newTasksMayBeScheduled = false;
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        while (!TimerThread.interrupted() && !this.queue.isclosed()) {
            try {
                boolean taskFired;
                TimerTask task = null;
                Object object = this.queue;
                synchronized (object) {
                    long executionTime;
                    long currentTime;
                    task = this.queue.getMin();
                    if (task == null) {
                        continue;
                    }
                    Object object2 = task.lock;
                    synchronized (object2) {
                        if (task.state == TimerTask.STATUS.CANCELLED) {
                            this.queue.removeMin();
                            continue;
                        }
                        currentTime = System.currentTimeMillis();
                        executionTime = task.getNextExecutionTime();
                        Calendar now = Calendar.getInstance();
                        now.setTimeInMillis(currentTime);
                        taskFired = executionTime <= currentTime;
                        if (taskFired) {
                            if (task.getRate() == 0L) {
                                this.queue.removeMin();
                            } else if (task.getExecutionType() == TimerTask.EXECUTION_TYPE.FIXED_RATE) {
                                this.queue.rescheduleMin(currentTime + task.getRate());
                            } else if (task.getExecutionType() == TimerTask.EXECUTION_TYPE.FIXED_DELAY) {
                                this.queue.rescheduleMin(executionTime + task.getRate());
                            } else {
                                this.queue.removeMin();
                            }
                        }
                    }
                    if (!taskFired) {
                        this.queue.wait(executionTime - currentTime);
                    }
                }
                if (!taskFired) continue;
                task.run();
                if (task.getRate() == 0L) {
                    task.setState(TimerTask.STATUS.EXECUTED);
                    continue;
                }
                if (task.getExecutionType() != TimerTask.EXECUTION_TYPE.FIXED_DELAY_POST_EXECUTION) continue;
                object = task.lock;
                synchronized (object) {
                    task.setState(TimerTask.STATUS.SCHEDULED);
                    task.setNextExecutionTime(System.currentTimeMillis() + task.getRate());
                    Calendar time = Calendar.getInstance();
                    time.setTimeInMillis(task.getNextExecutionTime());
                }
                this.queue.add(task);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

