/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.utils;

import java.util.Calendar;

public abstract class TimerTask
implements Runnable {
    final Object lock = new Object();
    STATUS state = STATUS.VIRGIN;
    private long nextExecutionTime;
    private long rate = 0L;
    private int index = 0;
    private EXECUTION_TYPE executionType = null;
    private String name;

    protected TimerTask() {
    }

    protected TimerTask(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.state == STATUS.SCHEDULED;
            this.state = STATUS.CANCELLED;
            return result;
        }
    }

    public EXECUTION_TYPE getExecutionType() {
        return this.executionType;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Calendar getNextExecutionDate() {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(this.nextExecutionTime);
        return date;
    }

    public void getNextExecutionDate(Calendar date) {
        if (date != null) {
            this.nextExecutionTime = date.getTimeInMillis();
        }
    }

    public long getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    public int getPriority() {
        return this.index;
    }

    public long getRate() {
        return this.rate;
    }

    public STATUS getState() {
        return this.state;
    }

    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scheduledExecutionTime() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.executionType) {
                case FIXED_RATE: {
                    return System.currentTimeMillis() + this.rate;
                }
                case FIXED_DELAY: {
                    return this.nextExecutionTime + this.rate;
                }
                case FIXED_DELAY_POST_EXECUTION: {
                    return this.nextExecutionTime + this.rate;
                }
            }
            return this.rate < 0L ? this.nextExecutionTime + this.rate : this.nextExecutionTime - this.rate;
        }
    }

    public void setExecutionType(EXECUTION_TYPE executionType) {
        this.executionType = executionType;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNextExecutionTime(long nextExecutionTime) {
        this.nextExecutionTime = nextExecutionTime;
    }

    public void setRate(long rate) {
        this.rate = rate;
    }

    public void setState(STATUS state) {
        this.state = state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EXECUTION_TYPE {
        FIXED_RATE,
        FIXED_DELAY,
        FIXED_DELAY_POST_EXECUTION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATUS {
        VIRGIN,
        SCHEDULED,
        EXECUTED,
        CANCELLED;

    }
}

