/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.jndi.provider.fscachedprovider;

import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.CEResource;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.CacheEntry;

public class ContextCache {
    private static Logger logger = Logger.getLogger((String)ContextCache.class.getName());
    private static final long serialVersionUID = 1L;
    private TreeMap cache;
    private int cacheMaxSize = 100;
    private String name;

    public ContextCache() {
        this(null);
    }

    public ContextCache(String name) {
        this.name = name;
        this.cache = new TreeMap();
    }

    public ContextCache(int size) {
        if (size > 0) {
            this.cacheMaxSize = size;
        }
        this.cache = new TreeMap();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String key, CEResource obj) throws Exception {
        if (obj == null) {
            return;
        }
        if (this.cache.containsKey(key)) {
            throw new Exception("The entry key \"" + key + "\" already exist!");
        }
        TreeMap treeMap = this.cache;
        synchronized (treeMap) {
            if (this.cache.size() + 1 - this.cacheMaxSize > 0) {
                int x = this.cacheMaxSize * 20 / 100;
                for (int i = 0; i < x; ++i) {
                    this.cache.remove(this.cache.firstKey());
                }
            }
            CacheEntry entry = new CacheEntry(System.currentTimeMillis(), (CEResource)obj.clone());
            this.cache.put(key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unload(String key) {
        if (this.cache.containsKey(key)) {
            TreeMap treeMap = this.cache;
            synchronized (treeMap) {
                this.cache.remove(key);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String key, CEResource obj) throws Exception {
        if (obj == null) {
            return;
        }
        if (!this.cache.containsKey(key)) {
            throw new Exception("The entry key \"" + key + "\" doesn't exist!");
        }
        TreeMap treeMap = this.cache;
        synchronized (treeMap) {
            CacheEntry entry = new CacheEntry(System.currentTimeMillis(), (CEResource)obj.clone());
            this.cache.put(key, entry);
        }
    }

    public CEResource lookup(String key) {
        if (key == null || this.cache == null) {
            return null;
        }
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        if (entry != null) {
            return (CEResource)entry.getCEResource().clone();
        }
        return null;
    }

    public String cacheStatus() {
        StringBuffer buff = new StringBuffer("\n");
        for (String key : this.cache.keySet()) {
            buff.append(key).append("\n");
        }
        return buff.toString();
    }

    public static void main(String[] args) throws Exception {
    }
}

