/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.jndi.provider.fscachedprovider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.CEResource;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.CacheLock;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.ContextCache;

public class CacheManager {
    private static Logger logger = Logger.getLogger((String)CacheManager.class.getName());
    public static String ROOT_ATTRS_FILE = "..root-attributes";
    public static final int MUST_BE_OBJECT = 0;
    public static final int MUST_BE_CONTEXT = 1;
    protected String absoluteBase;
    protected ContextCache objCache;
    protected ContextCache attrCache;
    protected CacheLock mutex;

    public CacheManager(String base) {
        this.absoluteBase = base;
        this.objCache = new ContextCache("OBJECT CACHE");
        this.attrCache = new ContextCache("ATTRIBUTE CACHE");
        this.mutex = new CacheLock();
    }

    public CacheManager(String base, int cacheSize) {
        this(base);
        this.objCache.setCacheMaxSize(cacheSize);
        this.attrCache.setCacheMaxSize(cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Name name) throws NamingException {
        this.mutex.lock(name, 0);
        String oName = name.toString();
        Object result = this.objCache.lookup(oName);
        try {
            if (result == null) {
                File file = new File(this.absoluteBase + File.separator + oName);
                if (!file.exists()) {
                    throw new NameNotFoundException(oName);
                }
                if (file.isDirectory()) {
                    result = file;
                } else {
                    result = this.retrieveObject(this.absoluteBase + File.separator + oName);
                    if (result instanceof CEResource) {
                        try {
                            this.objCache.load(oName, (CEResource)result);
                        }
                        catch (Exception ex) {
                            logger.debug((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
            }
            Object var7_6 = null;
            this.mutex.unlock(name, 0);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.mutex.unlock(name, 0);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes getAttributes(Name name) throws NamingException {
        this.mutex.lock(name, 0);
        String bName = this.getBindingsName(name);
        Attributes loadedAttrs = (Attributes)((Object)this.attrCache.lookup(bName));
        try {
            if (loadedAttrs == null) {
                loadedAttrs = (Attributes)this.retrieveObject(this.absoluteBase + File.separator + bName);
                try {
                    this.attrCache.load(bName, (CEResource)((Object)loadedAttrs));
                }
                catch (Exception ex) {
                    logger.debug((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            Object var6_5 = null;
            this.mutex.unlock(name, 0);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mutex.unlock(name, 0);
            throw throwable;
        }
        return loadedAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAttributeList(Name name) throws NamingException {
        this.mutex.lock(name, 3);
        ArrayList<Object[]> list = null;
        try {
            String oName = name.toString();
            File file = new File(this.absoluteBase + File.separator + oName);
            if (!file.exists()) {
                throw new NameNotFoundException(oName);
            }
            if (!file.isDirectory()) {
                throw new NotContextException(oName);
            }
            String[] tmpl = file.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(".") && !name.startsWith("..");
                }
            });
            if (tmpl == null) {
                throw new NamingException("getAttributeList error: the file.list(filter) returned null list. This problem occurs when the pathname (" + this.absoluteBase + File.separator + oName + ") does not denote a directory, or I/O error occured");
            }
            list = new ArrayList<Object[]>(tmpl.length);
            for (int k = 0; k < tmpl.length; ++k) {
                Name itemName = ((Name)name.clone()).add(tmpl[k].substring(1));
                Object[] pair = new Object[]{itemName, this.getAttributes(itemName)};
                list.add(pair);
            }
            Object var10_9 = null;
            this.mutex.unlock(name, 3);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.mutex.unlock(name, 3);
            throw throwable;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(Name name, Object obj, Attributes attrs, boolean overwriteObj) throws NamingException {
        block13: {
            File objFile;
            boolean cannotPutObj;
            block12: {
                this.mutex.lock(name, 1);
                cannotPutObj = false;
                boolean cannotPutAttr = false;
                String bName = this.getBindingsName(name);
                objFile = new File(this.absoluteBase + File.separator + name);
                try {
                    if (attrs != null) {
                        cannotPutAttr = true;
                        this.storeObject(this.absoluteBase + File.separator + bName, attrs);
                        cannotPutAttr = false;
                        this.updateCache(bName, attrs, overwriteObj);
                    }
                    if (obj != null && !(obj instanceof Context)) {
                        if (!overwriteObj && objFile.exists()) {
                            throw new NameAlreadyBoundException("Object already exists " + name);
                        }
                        if (overwriteObj && !objFile.exists()) {
                            throw new NameAlreadyBoundException("Object doesn't exist " + name);
                        }
                        cannotPutObj = true;
                        this.storeObject(this.absoluteBase + File.separator + name, obj);
                        cannotPutObj = false;
                        this.updateCache(name.toString(), obj, overwriteObj);
                    }
                    Object var10_9 = null;
                    if (!cannotPutAttr && !cannotPutObj) break block12;
                    this.attrCache.unload(bName);
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (cannotPutAttr || cannotPutObj) {
                        this.attrCache.unload(bName);
                        File attrFile = new File(this.absoluteBase + File.separator + bName);
                        if (!attrFile.delete()) {
                            logger.warn((Object)("Cannot remove corrupted file: " + attrFile.getAbsolutePath()));
                        }
                    }
                    if (cannotPutObj) {
                        this.objCache.unload(name.toString());
                        if (!objFile.delete()) {
                            logger.warn((Object)("Cannot remove corrupted file: " + objFile.getAbsolutePath()));
                        }
                    }
                    this.mutex.unlock(name, 1);
                    throw throwable;
                }
                File attrFile = new File(this.absoluteBase + File.separator + bName);
                if (!attrFile.delete()) {
                    logger.warn((Object)("Cannot remove corrupted file: " + attrFile.getAbsolutePath()));
                }
            }
            if (!cannotPutObj) break block13;
            this.objCache.unload(name.toString());
            if (!objFile.delete()) {
                logger.warn((Object)("Cannot remove corrupted file: " + objFile.getAbsolutePath()));
            }
        }
        this.mutex.unlock(name, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList recursiveRemove(Name name, int checkDir) throws NamingException {
        this.mutex.lock(name, 2);
        ArrayList result = new ArrayList(0);
        try {
            String oName = name.toString();
            File file = new File(this.absoluteBase + File.separator + oName);
            if (!file.exists()) {
                throw new NameNotFoundException(oName);
            }
            if (file.isDirectory() && checkDir == 0) {
                throw new NamingException("Cannot unbind the context " + oName);
            }
            if (!file.isDirectory() && checkDir == 1) {
                throw new NotContextException(oName);
            }
            this.removeObject(name, result);
            Object var7_6 = null;
            this.mutex.unlock(name, 2);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.mutex.unlock(name, 2);
            throw throwable;
        }
        return result;
    }

    private void removeObject(Name name, ArrayList buffer) throws NamingException {
        String oName = name.toString();
        String bName = this.getBindingsName(name);
        Object oldObj = null;
        CEResource oldAttrs = null;
        File file = new File(this.absoluteBase + File.separator + oName);
        if (file.isDirectory()) {
            String[] list = file.list(new FilenameFilter(){

                public boolean accept(File dir, String fName) {
                    return !fName.startsWith(".");
                }
            });
            for (int k = 0; k < list.length; ++k) {
                Name itemName = ((Name)name.clone()).add(list[k]);
                this.removeObject(itemName, buffer);
            }
            oldObj = new String();
            oldAttrs = this.attrCache.lookup(bName);
        } else {
            oldObj = this.objCache.lookup(oName);
            oldAttrs = this.attrCache.lookup(bName);
            if (oldObj == null) {
                try {
                    oldObj = this.retrieveObject(this.absoluteBase + File.separator + oName);
                }
                catch (CommunicationException cEx) {
                    logger.debug((Object)("Spurious file " + oName));
                }
            }
        }
        this.objCache.unload(oName);
        this.attrCache.unload(bName);
        if (!file.delete()) {
            throw new NamingException("Cannot delete " + file.getAbsolutePath());
        }
        File bFile = new File(this.absoluteBase + File.separator + bName);
        if (bFile.exists() && !bFile.delete()) {
            throw new NamingException("Cannot delete " + bFile.getAbsolutePath());
        }
        buffer.add(new Object[]{name, oldObj, oldAttrs});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContext(Name name, Attributes attrs) throws NamingException {
        String oName = name.toString();
        File file = new File(this.absoluteBase + File.separator + oName);
        if (file.isDirectory()) {
            this.getAttributes(name);
        } else {
            block6: {
                this.mutex.lock(name, 1);
                String bName = this.getBindingsName(name);
                boolean cannotCreate = true;
                try {
                    if (!file.mkdir() || attrs == null) {
                        throw new NamingException("Cannot create subcontext " + oName);
                    }
                    this.storeObject(this.absoluteBase + File.separator + bName, attrs);
                    cannotCreate = false;
                    this.updateCache(bName, attrs, false);
                    Object var8_7 = null;
                    if (!cannotCreate) break block6;
                    file.delete();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (cannotCreate) {
                        file.delete();
                        new File(bName).delete();
                    }
                    this.mutex.unlock(name, 1);
                    throw throwable;
                }
                new File(bName).delete();
            }
            this.mutex.unlock(name, 1);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameObject(Name srcName, Name trgName) throws NamingException {
        String source = srcName.toString();
        String bSource = this.getBindingsName(srcName);
        File sourceFile = new File(this.absoluteBase + File.separator + source);
        File bSourceFile = new File(this.absoluteBase + File.separator + bSource);
        String target = trgName.toString();
        String bTarget = this.getBindingsName(trgName);
        File targetFile = new File(this.absoluteBase + File.separator + target);
        File bTargetFile = new File(this.absoluteBase + File.separator + bTarget);
        this.mutex.lock(srcName, 2);
        this.mutex.lock(trgName, 1);
        try {
            if (!sourceFile.getParent().equals(targetFile.getParent())) {
                throw new OperationNotSupportedException("Do not support rename across different contexts");
            }
            if (!bSourceFile.renameTo(bTargetFile)) {
                throw new NamingException("Cannot rename " + source);
            }
            if (!sourceFile.renameTo(targetFile)) {
                bTargetFile.renameTo(bSourceFile);
                throw new NamingException("Cannot rename " + source);
            }
            CEResource tmpRes = this.objCache.lookup(source);
            CEResource tmpBinds = this.attrCache.lookup(bSource);
            try {
                if (tmpRes != null) {
                    this.objCache.unload(source);
                    this.objCache.load(target, tmpRes);
                }
                if (tmpBinds != null) {
                    this.attrCache.unload(bSource);
                    this.attrCache.load(bTarget, tmpBinds);
                }
            }
            catch (Exception ex) {
                logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            Object var15_14 = null;
            this.mutex.unlock(srcName, 2);
            this.mutex.unlock(trgName, 1);
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            this.mutex.unlock(srcName, 2);
            this.mutex.unlock(trgName, 1);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    protected Object retrieveObject(String filename) throws NamingException {
        Object obj;
        block14: {
            Exception ex22;
            ObjectInputStream ois;
            FileInputStream fis;
            block13: {
                fis = null;
                ois = null;
                obj = null;
                fis = new FileInputStream(filename);
                ois = new ObjectInputStream(fis);
                obj = ois.readObject();
                Object var7_5 = null;
                if (ois == null) break block13;
                try {
                    ois.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex22) {}
            }
            break block14;
            {
                catch (Exception ex3) {
                    logger.debug((Object)("retrieveObject: cannot retrieve the file \"" + filename + "\"\n" + ex3.getMessage()));
                    throw new NamingException(ex3.getMessage());
                }
            }
            catch (Throwable throwable) {
                Exception ex22;
                Object var7_6 = null;
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return obj;
    }

    /*
     * Loose catch block
     */
    protected void storeObject(String fileName, Object obj) throws NamingException {
        block16: {
            Exception ex22;
            ObjectOutputStream oos;
            FileOutputStream fos;
            block15: {
                if (obj == null) {
                    return;
                }
                fos = null;
                oos = null;
                fos = new FileOutputStream(fileName);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(obj);
                Object var7_5 = null;
                if (oos == null) break block15;
                try {
                    oos.flush();
                    oos.close();
                }
                catch (Exception ex22) {
                    logger.error((Object)("storeObject error: " + ex22.getMessage()));
                }
            }
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (Exception ex22) {
                    logger.error((Object)("storeObject error: " + ex22.getMessage()));
                }
            }
            break block16;
            {
                catch (FileNotFoundException e) {
                    throw new NamingException(e.getMessage());
                }
                catch (IOException ioEx) {
                    throw new NamingException(ioEx.getMessage());
                }
            }
            catch (Throwable throwable) {
                Exception ex22;
                Object var7_6 = null;
                if (oos != null) {
                    try {
                        oos.flush();
                        oos.close();
                    }
                    catch (Exception ex22) {
                        logger.error((Object)("storeObject error: " + ex22.getMessage()));
                    }
                }
                if (fos != null) {
                    try {
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception ex22) {
                        logger.error((Object)("storeObject error: " + ex22.getMessage()));
                    }
                }
                throw throwable;
            }
        }
    }

    private void updateCache(String oName, Object obj, boolean overwrite) {
        ContextCache cache;
        if (obj == null || !(obj instanceof CEResource) || oName == null) {
            return;
        }
        ContextCache contextCache = cache = obj instanceof Attributes ? this.attrCache : this.objCache;
        if (cache == null) {
            return;
        }
        try {
            if (overwrite) {
                try {
                    cache.update(oName, (CEResource)obj);
                }
                catch (Exception e) {
                    cache.load(oName, (CEResource)obj);
                }
            } else {
                cache.load(oName, (CEResource)obj);
            }
        }
        catch (Exception ex) {
            logger.debug((Object)ex.getMessage());
        }
    }

    protected String getBindingsName(Name name) throws NamingException {
        Name result = (Name)name.clone();
        if (name.size() == 0) {
            result.add(ROOT_ATTRS_FILE);
        } else {
            result.remove(result.size() - 1);
            result.add("." + name.get(name.size() - 1));
        }
        return result.toString();
    }
}

