/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.jndi.provider.fscachedprovider;

import java.util.Iterator;
import javax.naming.Name;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.CacheLockBin;

public class CacheLock {
    private static Logger logger = Logger.getLogger((String)CacheLock.class.getName());
    public static final int READ_OPERATION = 0;
    public static final int WRITE_OPERATION = 1;
    public static final int DELETE_OPERATION = 2;
    public static final int LIST_OPERATION = 3;
    public static final int NUM_OF_OPERATION = 4;
    private CacheLockBin rootBin = new CacheLockBin();

    public synchronized void lock(Name name, int op) {
        CacheLockBin tmpBin;
        int k;
        logger.debug((Object)("Locking " + name.toString() + " code " + op));
        CacheLockBin currentBin = this.rootBin;
        currentBin.incrReserved(op);
        for (k = 0; k < name.size(); ++k) {
            tmpBin = (CacheLockBin)currentBin.get(name.get(k));
            if (tmpBin == null) {
                tmpBin = new CacheLockBin();
                currentBin.put(name.get(k), tmpBin);
            }
            tmpBin.incrReserved(op);
            currentBin = tmpBin;
        }
        currentBin = this.rootBin;
        currentBin.incrCount(op);
        for (k = 0; k < name.size(); ++k) {
            tmpBin = (CacheLockBin)currentBin.get(name.get(k));
            tmpBin.incrCount(op);
            while (this.isBlockedIn(op, tmpBin)) {
                logger.debug((Object)("Operation " + op + " locked on " + name.get(k)));
                try {
                    this.wait();
                }
                catch (InterruptedException intEx) {}
            }
            currentBin = tmpBin;
        }
        while (this.isBlockedIn(op, currentBin) || this.isScopeBlocked(op, currentBin)) {
            logger.debug((Object)("Operation " + op + " locked on destination"));
            try {
                this.wait();
            }
            catch (InterruptedException intEx) {}
        }
        currentBin.addOpLock(op);
        logger.debug((Object)("Locked " + name.toString() + " code " + op));
    }

    public synchronized void unlock(Name name, int op) {
        logger.debug((Object)("Unlocking " + name.toString() + " code " + op));
        CacheLockBin currentBin = this.rootBin;
        currentBin.decrReserved(op);
        currentBin.decrCount(op);
        boolean notRemoved = true;
        for (int k = 0; k < name.size() && notRemoved; ++k) {
            CacheLockBin tmpBin = (CacheLockBin)currentBin.get(name.get(k));
            tmpBin.decrReserved(op);
            tmpBin.decrCount(op);
            if (tmpBin.getReserved() == 0) {
                logger.debug((Object)("Removing subtree rooted at " + name.get(k)));
                currentBin.remove(name.get(k));
                notRemoved = false;
                break;
            }
            currentBin = tmpBin;
        }
        logger.debug((Object)("Unlocked " + name.toString() + " code " + op));
        if (notRemoved) {
            currentBin.removeOpLock(op);
        }
        this.notify();
    }

    private boolean isBlockedIn(int op, CacheLockBin clBin) {
        if (clBin.isFree()) {
            return false;
        }
        int[] opLock = clBin.getOpLock();
        return op != 0 && op != 3 || opLock[1] != 0 || opLock[2] != 0;
    }

    private boolean isScopeBlocked(int op, CacheLockBin clBin) {
        if (op == 2) {
            return clBin.getCount() > 1;
        }
        if (op == 3) {
            Iterator childList = clBin.values().iterator();
            while (childList.hasNext()) {
                int[] childOpLock = ((CacheLockBin)childList.next()).getOpLock();
                if (childOpLock[1] <= 0 && childOpLock[2] <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private void printBinStatus(String name, CacheLockBin clBin) {
        int j;
        StringBuffer buff = new StringBuffer("(" + name + ")  OpLock [");
        int[] opLock = clBin.getOpLock();
        for (j = 0; j < 4; ++j) {
            buff.append(opLock[j] + " ");
        }
        buff.append("]  OpCount [");
        for (j = 0; j < 4; ++j) {
            buff.append(clBin.getCount(j) + " ");
        }
        buff.append("]  OpReserved [");
        for (j = 0; j < 4; ++j) {
            buff.append(clBin.getReserved(j) + " ");
        }
        buff.append("]");
        logger.debug((Object)buff.toString());
    }
}

