/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.jndi.provider.fscachedprovider;

import org.glite.ce.commonj.CEResource;

public class CacheEntry
implements Comparable {
    private long timestamp = 0L;
    private CEResource ceResource;

    public CacheEntry(long timestamp, CEResource resource) throws Exception {
        if (timestamp < 0L) {
            throw new Exception("The timestamp value must be > 0");
        }
        if (resource == null) {
            throw new Exception("The resource obj must be not null");
        }
        this.timestamp = timestamp;
        this.ceResource = resource;
    }

    public CEResource getCEResource() {
        return this.ceResource;
    }

    public int getSize() {
        return this.ceResource.toString().getBytes().length;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int compareTo(Object obj) {
        if (obj instanceof CacheEntry) {
            if (this.timestamp < ((CacheEntry)obj).getTimestamp()) {
                return -1;
            }
            return this.timestamp == ((CacheEntry)obj).getTimestamp() ? 0 : 1;
        }
        return 0;
    }
}

