/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.jndi.provider.fscachedprovider;

import java.util.ArrayList;
import javax.naming.Name;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.CEEventItem;

public class CEEventManager {
    private static Logger logger = Logger.getLogger((String)CEEventManager.class.getName());
    private CEEventItem root = new CEEventItem();

    public synchronized void register(Name target, int scope, NamingListener lsnr) {
        int k;
        CEEventItem currentItem = this.root;
        for (k = 0; k < target.size(); ++k) {
            currentItem = currentItem.createSubItem(target.get(k));
        }
        if (currentItem.addListener(lsnr, scope)) {
            currentItem = this.root;
            currentItem.incrementDeps(1);
            for (k = 0; k < target.size(); ++k) {
                currentItem = currentItem.getItem(target.get(k));
                currentItem.incrementDeps(1);
            }
        }
    }

    private void removeItem(Name target, NamingListener lsnr) {
        CEEventItem currentItem = this.root;
        for (int k = 0; k < target.size(); ++k) {
            if ((currentItem = currentItem.getItem(target.get(k))) != null) continue;
            return;
        }
        int nLsnr = 0;
        nLsnr = lsnr != null ? currentItem.removeListener(lsnr) : currentItem.removeAllListeners();
        if (nLsnr == 0) {
            return;
        }
        currentItem = this.root;
        currentItem.decrementDeps(nLsnr);
        CEEventItem prevItem = this.root;
        for (int k = 0; k < target.size(); ++k) {
            currentItem = currentItem.getItem(target.get(k));
            currentItem.decrementDeps(nLsnr);
            if (!currentItem.hasDeps()) {
                prevItem.removeItem(target.get(k));
                return;
            }
            prevItem = currentItem;
        }
    }

    public synchronized void remove(Name target, NamingListener lsnr) {
        this.removeItem(target, lsnr);
    }

    public synchronized void removeAll(Name target) {
        this.removeItem(target, null);
    }

    public synchronized Tuple[] getListeners(Name target, int type) {
        CEEventItem currentItem = null;
        Object lsnrs = null;
        ArrayList resList = new ArrayList();
        block4: for (int k = 0; k <= target.size(); ++k) {
            Name source = target.getPrefix(k);
            if (source.isEmpty()) {
                currentItem = this.root;
            } else if ((currentItem = currentItem.getItem(target.get(k - 1))) == null) break;
            this.collectListener(currentItem, 2, type, source, resList);
            switch (target.size() - k) {
                case 0: {
                    this.collectListener(currentItem, 0, type, source, resList);
                    continue block4;
                }
                case 1: {
                    this.collectListener(currentItem, 1, type, source, resList);
                }
            }
        }
        Tuple[] result = new Tuple[resList.size()];
        resList.toArray(result);
        return result;
    }

    private void collectListener(CEEventItem evnItem, int scopeType, int evnType, Name src, ArrayList list) {
        NamingListener[] lsnrs = evnItem.getListeners(scopeType);
        for (int j = 0; j < lsnrs.length; ++j) {
            if ((evnType != 3 || !(lsnrs[j] instanceof ObjectChangeListener)) && (evnType == 3 || !(lsnrs[j] instanceof NamespaceChangeListener))) continue;
            list.add(new Tuple(lsnrs[j], src));
        }
    }

    public class Tuple {
        private NamingListener listener;
        private Name source;

        public Tuple(NamingListener lsnr, Name src) {
            this.listener = lsnr;
            this.source = src;
        }

        public NamingListener getListener() {
            return this.listener;
        }

        public Name getSource() {
            return this.source;
        }
    }
}

