/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.jndi.provider.fscachedprovider;

import java.util.HashMap;
import java.util.Iterator;
import javax.naming.event.NamingListener;
import org.apache.log4j.Logger;

public final class CEEventItem {
    private static Logger logger = Logger.getLogger((String)CEEventItem.class.getName());
    private HashMap children = new HashMap(0);
    private HashMap scopes = new HashMap(0);
    private int numberOfObjectScopes = 0;
    private int numberOfOneLevelScopes = 0;
    private int numberOfSubtreeScopes = 0;
    private int dependencies = 0;

    public boolean addListener(NamingListener lsnr, int scope) {
        boolean result = this.removeListener(lsnr) == 0;
        this.scopes.put(lsnr, new Integer(scope));
        if (scope == 0) {
            ++this.numberOfObjectScopes;
        } else if (scope == 1) {
            ++this.numberOfOneLevelScopes;
        } else {
            ++this.numberOfSubtreeScopes;
        }
        return result;
    }

    public int removeListener(NamingListener lsnr) {
        Integer scope = (Integer)this.scopes.remove(lsnr);
        if (scope != null) {
            int sc = scope;
            if (sc == 0) {
                --this.numberOfObjectScopes;
            } else if (sc == 1) {
                --this.numberOfOneLevelScopes;
            } else {
                --this.numberOfSubtreeScopes;
            }
            return 1;
        }
        return 0;
    }

    public int removeAllListeners() {
        int result = this.scopes.size();
        this.scopes.clear();
        this.numberOfObjectScopes = 0;
        this.numberOfOneLevelScopes = 0;
        this.numberOfSubtreeScopes = 0;
        return result;
    }

    public NamingListener[] getListeners(int scope) {
        NamingListener[] result = null;
        result = scope == 0 ? new NamingListener[this.numberOfObjectScopes] : (scope == 1 ? new NamingListener[this.numberOfOneLevelScopes] : new NamingListener[this.numberOfSubtreeScopes]);
        if (result.length == 0) {
            return result;
        }
        Iterator lsnrItem = this.scopes.keySet().iterator();
        int k = 0;
        while (lsnrItem.hasNext()) {
            NamingListener lsnr = (NamingListener)lsnrItem.next();
            int tmpsc = (Integer)this.scopes.get(lsnr);
            if (tmpsc == scope) {
                result[k] = lsnr;
            }
            ++k;
        }
        return result;
    }

    public CEEventItem createSubItem(String child) {
        CEEventItem result = (CEEventItem)this.children.get(child);
        if (result == null) {
            result = new CEEventItem();
            this.children.put(child, result);
        }
        return result;
    }

    public CEEventItem getItem(String child) {
        return (CEEventItem)this.children.get(child);
    }

    public boolean removeItem(String child) {
        return this.children.remove(child) != null;
    }

    public void incrementDeps(int d) {
        this.dependencies += d;
    }

    public void decrementDeps(int d) {
        this.dependencies = this.dependencies >= d ? (this.dependencies -= d) : 0;
    }

    public boolean hasDeps() {
        return this.dependencies > 0;
    }
}

