/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.db;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)DatasourceConfigHandler.class.getName());
    private static final String[] DATASOURCE_ATTRIBUTES = new String[]{"factory", "driverClassName", "username", "password", "maxActive", "maxIdle", "maxWait", "logAbandoned", "removeAbandoned", "removeAbandonedTimeout", "url", "validationQuery", "testOnBorrow", "testWhileIdle", "timeBetweenEvictionRunsMillis", "minEvictableIdleTimeMillis"};
    private static final String XPATH_STRING = "/service/dataSource";
    private XPathExpression expr;
    private List<HashMap<String, String>> currentParams;
    private List<HashMap<String, String>> tmpParams;
    private HashMap<String, DataSource> currentDatasources;

    public DatasourceConfigHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
        this.currentParams = new ArrayList<HashMap<String, String>>(0);
        this.tmpParams = null;
        this.currentDatasources = null;
    }

    @Override
    public XPathExpression getXPath() {
        return this.expr;
    }

    @Override
    public Class<?> getCategory() {
        return HashMap.class;
    }

    @Override
    public Object[] getConfigurationElement() {
        Object[] datasourceMap = null;
        datasourceMap = this.currentDatasources == null || this.currentDatasources.size() == 0 ? new HashMap[]{} : new HashMap[]{this.currentDatasources};
        return datasourceMap;
    }

    @Override
    public boolean process(NodeList parsedElements) throws CommonConfigException {
        Node node = null;
        HashMap<String, String> dataSourceAttributes = null;
        this.tmpParams = new ArrayList<HashMap<String, String>>(0);
        for (int k = 0; k < parsedElements.getLength(); ++k) {
            int i;
            Element dsElem = (Element)parsedElements.item(k);
            NamedNodeMap namedNodeMap = dsElem.getAttributes();
            if (namedNodeMap == null) continue;
            dataSourceAttributes = new HashMap<String, String>(0);
            for (i = 0; i < namedNodeMap.getLength(); ++i) {
                node = namedNodeMap.item(i);
                dataSourceAttributes.put(node.getNodeName(), node.getNodeValue());
            }
            for (i = 0; i < DATASOURCE_ATTRIBUTES.length; ++i) {
                if (dataSourceAttributes.containsKey(DATASOURCE_ATTRIBUTES[i])) continue;
                throw new CommonConfigException("Missing data source attribute: " + DATASOURCE_ATTRIBUTES[i]);
            }
            this.tmpParams.add(dataSourceAttributes);
        }
        boolean result = !((Object)this.currentParams).equals(this.tmpParams);
        logger.debug((Object)("Datasource configuration changed: " + result));
        return result;
    }

    @Override
    public boolean processTriggers() {
        return false;
    }

    @Override
    public void commit() {
        this.currentParams = this.tmpParams;
        this.tmpParams = null;
        this.currentDatasources = new HashMap(this.currentParams.size());
        for (HashMap<String, String> dataSourceAttribute : this.currentParams) {
            String name = dataSourceAttribute.remove("name");
            String type = dataSourceAttribute.remove("type");
            String factory = dataSourceAttribute.remove("factory");
            Reference reference = new Reference(type);
            for (String attributeName : dataSourceAttribute.keySet()) {
                reference.add(new StringRefAddr(attributeName, dataSourceAttribute.get(attributeName)));
            }
            try {
                ObjectFactory objFactory = (ObjectFactory)Class.forName(factory).newInstance();
                this.currentDatasources.put(name, (DataSource)objFactory.getObjectInstance(reference, null, null, null));
                logger.debug((Object)("new dataSource added: " + name));
            }
            catch (Throwable th) {
                logger.error((Object)th.getMessage(), th);
            }
        }
    }

    @Override
    public void rollback() {
        this.tmpParams = null;
    }

    @Override
    public File[] getTriggers() {
        return null;
    }

    @Override
    public void clean() {
        this.currentParams.clear();
        this.tmpParams = null;
        this.currentDatasources = null;
    }
}

