/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm;

import java.io.File;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.glite.ce.commonj.configuration.xppm.ConfigurationManager;
import org.glite.ce.commonj.configuration.xppm.GlobalAttributes;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalAttributeHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)GlobalAttributeHandler.class.getName());
    private static final String XPATH_STRING = "/service/@*";
    private XPathExpression expr;
    private GlobalAttributes currentAttrs;
    private GlobalAttributes tmpAttrs;

    public GlobalAttributeHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
        this.currentAttrs = new GlobalAttributes();
        this.tmpAttrs = null;
    }

    @Override
    public XPathExpression getXPath() {
        return this.expr;
    }

    @Override
    public Class<?> getCategory() {
        return GlobalAttributes.class;
    }

    @Override
    public Object[] getConfigurationElement() {
        Object[] result = new Object[]{this.currentAttrs};
        return result;
    }

    @Override
    public boolean process(NodeList parsedElements) {
        this.tmpAttrs = new GlobalAttributes();
        for (int k = 0; k < parsedElements.getLength(); ++k) {
            Attr attribute = (Attr)parsedElements.item(k);
            this.tmpAttrs.put(attribute.getName(), attribute.getValue());
            logger.debug((Object)("Found attribute: " + attribute.getName() + " = " + attribute.getValue()));
        }
        boolean result = !this.tmpAttrs.equals(this.currentAttrs);
        logger.debug((Object)("GlobalAttributes changed: " + result));
        return result;
    }

    @Override
    public boolean processTriggers() {
        return false;
    }

    @Override
    public void commit() {
        this.currentAttrs = this.tmpAttrs;
        this.tmpAttrs = null;
    }

    @Override
    public void rollback() {
        this.tmpAttrs = null;
    }

    @Override
    public File[] getTriggers() {
        return null;
    }

    @Override
    public void clean() {
        this.currentAttrs.clear();
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"/tmp/log4j.properties");
        try {
            ConfigurationManager cMan = new ConfigurationManager(args[0]);
            Object[] tmpo = cMan.getConfigurationElements(GlobalAttributes.class);
            if (tmpo.length > 0) {
                GlobalAttributes attrs = (GlobalAttributes)tmpo[0];
                for (String key : attrs.keySet()) {
                    logger.info((Object)("Found " + key + " = " + (String)attrs.get(key)));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

