/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm;

import java.io.File;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationEvent;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.glite.ce.commonj.configuration.xppm.ConfigurationListener;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager
implements Runnable {
    private static Logger logger = Logger.getLogger((String)ConfigurationManager.class.getName());
    private static String REFRESH_TIME_LABEL = "configuration.manager.refresh.time";
    private static long REFRESH_TIME_DEFAULT = 5L;
    private ArrayList<ConfigurationHandler> handlerList;
    private String xmlFilename;
    private long lastTick;
    private long lastModificationTime;
    private long refreshTime;
    private ArrayList<ConfigurationListener> listeners;
    private Thread notifyThread;
    private boolean running;
    private boolean deadlockDetected;
    private ArrayBlockingQueue<ConfigurationEvent> eventQueue;

    public ConfigurationManager(String xmlFilename) throws CommonConfigException {
        this.xmlFilename = xmlFilename;
        File xmlFile = new File(xmlFilename);
        if (!xmlFile.isFile()) {
            throw new CommonConfigException("Wrong configuration file: " + xmlFilename);
        }
        this.lastTick = 0L;
        this.lastModificationTime = 0L;
        try {
            this.refreshTime = Long.parseLong(System.getProperty(REFRESH_TIME_LABEL)) * 1000L;
            if (this.refreshTime < 1000L) {
                this.refreshTime = 1000L;
            }
        }
        catch (Throwable th) {
            this.refreshTime = REFRESH_TIME_DEFAULT * 1000L;
        }
        this.handlerList = new ArrayList();
        ServiceLoader<ConfigurationHandler> serviceLoader = ServiceLoader.load(ConfigurationHandler.class);
        for (ConfigurationHandler cHandler : serviceLoader) {
            this.handlerList.add(cHandler);
            cHandler.disable();
            logger.debug((Object)("Loaded handler " + cHandler.getClass().getName()));
        }
        this.eventQueue = new ArrayBlockingQueue(1000);
        this.listeners = new ArrayList();
        this.notifyThread = new Thread((Runnable)this, "ConfigurationNotifier");
        this.running = false;
        this.deadlockDetected = false;
    }

    public ConfigurationManager(String xmlFilename, long rate) throws CommonConfigException {
        this(xmlFilename);
        this.refreshTime = rate / 2L;
        this.running = true;
        this.notifyThread.start();
    }

    public ConfigurationManager(String xmlFilename, long rate, ConfigurationListener[] listeners) throws CommonConfigException {
        this(xmlFilename);
        this.refreshTime = rate / 2L;
        for (ConfigurationListener lsnr : listeners) {
            this.addListener(lsnr);
        }
        this.running = true;
        this.notifyThread.start();
    }

    public synchronized Object[] getConfigurationElements(Class<?> category) {
        this.checkAndUpdate();
        ArrayList<Object> objList = new ArrayList<Object>();
        for (ConfigurationHandler cHandler : this.handlerList) {
            Object[] objArray;
            if (!cHandler.isEnabled() || !cHandler.getCategory().equals(category) || (objArray = cHandler.getConfigurationElement()) == null) continue;
            for (Object obj : objArray) {
                if (category.isInstance(obj)) {
                    objList.add(obj);
                    continue;
                }
                logger.error((Object)("Bad returned category for " + cHandler.getClass().getName()));
            }
        }
        Object[] result = new Object[objList.size()];
        objList.toArray(result);
        return result;
    }

    private void checkAndUpdate() {
        long now = System.currentTimeMillis();
        if (now - this.lastTick < this.refreshTime) {
            return;
        }
        this.lastTick = now;
        File xmlFile = new File(this.xmlFilename);
        long tmpTS = xmlFile.lastModified();
        if (tmpTS > this.lastModificationTime) {
            Document document = null;
            boolean commitOK = true;
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                logger.debug((Object)("Parsing file " + xmlFile));
                document = builder.parse(xmlFile);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
            try {
                for (ConfigurationHandler handler : this.handlerList) {
                    XPathExpression xpathExpr = handler.getXPath();
                    NodeList pElements = (NodeList)xpathExpr.evaluate(document, XPathConstants.NODESET);
                    if (pElements != null && pElements.getLength() > 0) {
                        if (!handler.isEnabled()) {
                            handler.scheduleForAdd();
                        }
                        if (!handler.process(pElements) || !handler.isEnabled()) continue;
                        handler.scheduleForUpdate();
                        continue;
                    }
                    if (!handler.isEnabled()) continue;
                    handler.scheduleForDelete();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                commitOK = false;
            }
            if (commitOK) {
                for (ConfigurationHandler handler : this.handlerList) {
                    try {
                        if (handler.isScheduledForAdd() || handler.isScheduledForUpdate()) {
                            handler.commit();
                            logger.debug((Object)("Committed " + handler.getCategory().getName()));
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        handler.disable();
                    }
                    if (handler.isScheduledForAdd()) {
                        handler.enable();
                        this.enqueueEvent(handler.getCategory(), tmpTS, 0);
                        continue;
                    }
                    if (handler.isScheduledForUpdate()) {
                        handler.enable();
                        this.enqueueEvent(handler.getCategory(), tmpTS, 1);
                        continue;
                    }
                    if (!handler.isScheduledForDelete()) continue;
                    handler.disable();
                    this.enqueueEvent(handler.getCategory(), tmpTS, 2);
                }
                this.lastModificationTime = tmpTS;
                for (ConfigurationHandler handler : this.handlerList) {
                    long tmpl;
                    if (!handler.isEnabled() || (tmpl = this.getLatestTriggerTime(handler)) <= this.lastModificationTime) continue;
                    this.lastModificationTime = tmpl;
                }
            } else {
                for (ConfigurationHandler handler : this.handlerList) {
                    try {
                        if (handler.isScheduledForAdd() || handler.isScheduledForUpdate()) {
                            handler.rollback();
                            logger.debug((Object)("Rolledback " + handler.getCategory().getName()));
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        handler.disable();
                    }
                    if (handler.isScheduledForAdd()) {
                        handler.disable();
                    }
                    if (!handler.isScheduledForDelete() && !handler.isScheduledForUpdate()) continue;
                    handler.enable();
                }
            }
        } else {
            long lastTriggerMod = 0L;
            boolean commitOK = true;
            try {
                for (ConfigurationHandler handler : this.handlerList) {
                    if (!handler.isEnabled()) continue;
                    long tmpl = this.getLatestTriggerTime(handler);
                    if (tmpl > lastTriggerMod) {
                        lastTriggerMod = tmpl;
                    }
                    if (tmpl <= this.lastModificationTime || !handler.processTriggers()) continue;
                    handler.scheduleForUpdate();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                commitOK = false;
            }
            for (ConfigurationHandler handler : this.handlerList) {
                if (!handler.isScheduledForUpdate()) continue;
                try {
                    if (commitOK) {
                        handler.commit();
                        this.enqueueEvent(handler.getCategory(), lastTriggerMod, 1);
                    } else {
                        handler.rollback();
                    }
                    handler.enable();
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    handler.disable();
                }
            }
            if (commitOK && lastTriggerMod > 0L) {
                this.lastModificationTime = lastTriggerMod;
            }
        }
    }

    private void enqueueEvent(Class<?> cat, long ts, int type) {
        if (this.running) {
            try {
                ConfigurationEvent event = new ConfigurationEvent(cat, ts, type);
                this.eventQueue.add(event);
            }
            catch (IllegalStateException illEx) {
                logger.error((Object)"Cannot enqueue event", (Throwable)illEx);
            }
        }
    }

    private long getLatestTriggerTime(ConfigurationHandler handler) {
        long result = 0L;
        File[] triggers = handler.getTriggers();
        if (triggers == null) {
            return result;
        }
        for (File trigger : triggers) {
            if (trigger.lastModified() <= result) continue;
            result = trigger.lastModified();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            this.checkAndUpdate();
        }
        while (this.running) {
            try {
                Object object;
                ConfigurationEvent event = this.eventQueue.poll(this.refreshTime * 2L, TimeUnit.MILLISECONDS);
                if (event != null) {
                    logger.debug((Object)("Read event " + event.getCategory().getName() + " " + event.getType()));
                    object = this.listeners;
                    synchronized (object) {
                        this.deadlockDetected = true;
                        for (ConfigurationListener lsnr : this.listeners) {
                            try {
                                lsnr.notify(event);
                            }
                            catch (Throwable th) {
                                logger.error((Object)th.getMessage(), th);
                            }
                        }
                        this.deadlockDetected = false;
                        continue;
                    }
                }
                object = this;
                synchronized (object) {
                    this.checkAndUpdate();
                }
            }
            catch (InterruptedException intEx) {
                if (this.running) {
                    logger.error((Object)"Notification dispatcher abruptly terminated");
                    return;
                }
                logger.info((Object)"Shutting down notification dispatcher");
            }
        }
        logger.info((Object)"ConfigurationNotifier halted");
    }

    public void shutdown() {
        if (this.running) {
            this.running = false;
            this.notifyThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigurationListener lsnr) {
        if (this.deadlockDetected) {
            logger.error((Object)"Deadlock detected, cannot add listener");
            throw new IllegalStateException("Deadlock detected");
        }
        ArrayList<ConfigurationListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigurationListener lsnr) {
        if (this.deadlockDetected) {
            logger.error((Object)"Deadlock detected, cannot remove listener");
            throw new IllegalStateException("Deadlock detected");
        }
        ArrayList<ConfigurationListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(lsnr);
        }
    }
}

