/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.authz.AdminTable;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationManager;
import org.glite.ce.commonj.configuration.xppm.GlobalAttributes;
import org.glite.ce.commonj.listeners.CommonContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonServiceConfig {
    private static Logger logger = Logger.getLogger((String)CommonServiceConfig.class.getName());
    protected ConfigurationManager confManager;
    private File configFile;

    protected CommonServiceConfig() throws CommonConfigException {
        String configFilename = CommonContextListener.getConfigPath();
        if (configFilename == null && this.getSysPropertyName() != null) {
            configFilename = System.getProperty(this.getSysPropertyName());
        }
        if (configFilename == null) {
            throw new CommonConfigException("Missing configuration source parameters");
        }
        try {
            this.configFile = new File(configFilename);
            if (!this.configFile.isFile() || !this.configFile.canRead()) {
                throw new CommonConfigException("Cannot read configuration file");
            }
            this.confManager = new ConfigurationManager(this.configFile.getCanonicalPath());
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new CommonConfigException("Wrong configuration file path");
        }
    }

    protected String getSysPropertyName() {
        return null;
    }

    public String getGlobalAttributeAsString(String name) {
        String attrString;
        Object[] tmpo = this.confManager.getConfigurationElements(GlobalAttributes.class);
        if (tmpo.length > 0 && (attrString = (String)((GlobalAttributes)tmpo[0]).get(name)) != null) {
            return attrString;
        }
        return "";
    }

    public int getGlobalAttributeAsInt(String name, int defValue) {
        Object[] tmpo = this.confManager.getConfigurationElements(GlobalAttributes.class);
        if (tmpo.length > 0) {
            GlobalAttributes attrs = (GlobalAttributes)tmpo[0];
            try {
                return Integer.parseInt((String)attrs.get(name));
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        return defValue;
    }

    public ServiceAuthorizationInterface getAuthorizationConfig() {
        Object[] tmpo = this.confManager.getConfigurationElements(ServiceAuthorizationInterface.class);
        if (tmpo.length > 0) {
            ServiceAuthorizationInterface authz = (ServiceAuthorizationInterface)tmpo[0];
            return authz;
        }
        return null;
    }

    public AdminTable getAdminTable() {
        Object[] tmpo = this.confManager.getConfigurationElements(AdminTable.class);
        if (tmpo.length > 0) {
            AdminTable adminTable = (AdminTable)tmpo[0];
            return adminTable;
        }
        return null;
    }

    public String getDistributionInfo() {
        StringBuffer result = new StringBuffer("EMI version: ");
        String distrInfoFilename = this.getGlobalAttributeAsString("distribution_filename");
        if (distrInfoFilename == "") {
            distrInfoFilename = System.getProperty("distribution_filename", "");
        }
        if (distrInfoFilename == "") {
            distrInfoFilename = "/etc/emi-version";
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(distrInfoFilename));
            String tmps = reader.readLine();
            if (tmps != null) {
                result.append(tmps.trim());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            result.append("unknown");
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return result.toString();
    }

    public String getConfigurationPath() {
        try {
            return this.configFile.getCanonicalPath();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getConfigurationDirectory() {
        return this.configFile.getParent();
    }

    public HashMap<String, DataSource> getDataSources() {
        HashMap dataSources = null;
        Object[] dataSourcesArray = this.confManager.getConfigurationElements(HashMap.class);
        if (dataSourcesArray != null && dataSourcesArray.length > 0) {
            dataSources = (HashMap)dataSourcesArray[0];
        }
        return dataSources;
    }

    public void destroy() {
        if (this.confManager != null) {
            this.confManager.shutdown();
        }
    }

    public void finalize() {
        if (this.confManager != null) {
            this.confManager.shutdown();
        }
    }
}

