/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.gjaf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.authz.AuthorizationException;
import org.glite.ce.commonj.authz.FQANPattern;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.axis2.AuthorizationModule;
import org.glite.ce.commonj.authz.gjaf.ChainConfig;
import org.glite.ce.commonj.authz.gjaf.CloseException;
import org.glite.ce.commonj.authz.gjaf.InitializeException;
import org.glite.ce.commonj.authz.gjaf.ServicePDP;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VomsServicePDP
implements ServicePDP {
    private static Logger logger = Logger.getLogger((String)VomsServicePDP.class.getName());
    public static final String GRID_MAP_FILE = "gridMapFile";
    private static final Pattern mapFilePattern = Pattern.compile("^\\s*\"((/[^=/\"]+)+(/[^/\"]+)*)\"\\s+([^\\s]+)\\s*$");
    private String id;
    private String gridMapFile;
    private HashMap<FQANPattern, String> fqanTable;
    private long timestamp;

    public VomsServicePDP() {
        this.id = "undef";
        this.timestamp = 0L;
    }

    public VomsServicePDP(String id) {
        this.id = id;
        this.timestamp = 0L;
    }

    @Override
    public void initialize(ChainConfig config, String name, String id) throws InitializeException {
        String mapFile = (String)config.getProperty(name, GRID_MAP_FILE);
        if (mapFile == null) {
            logger.error((Object)"Gridmap file not specified");
            throw new InitializeException("Gridmap file not specified");
        }
        this.readGridmapFile(mapFile);
        this.gridMapFile = mapFile;
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setProperty(String name, String value) throws InitializeException {
        if (name.equals(GRID_MAP_FILE)) {
            this.readGridmapFile(value);
            this.gridMapFile = value;
        }
    }

    @Override
    public String getProperty(String name) {
        if (name.equals(GRID_MAP_FILE)) {
            return this.gridMapFile;
        }
        return null;
    }

    @Override
    public String[] getProperties() {
        return new String[]{GRID_MAP_FILE};
    }

    @Override
    public boolean isTriggerable(String name) {
        return name.equals(GRID_MAP_FILE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readGridmapFile(String mapFile) throws InitializeException {
        logger.debug((Object)("Initializing gridmap service PDP with " + mapFile));
        this.timestamp = System.currentTimeMillis();
        this.fqanTable = new HashMap();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(mapFile));
                String line = reader.readLine();
                while (line != null) {
                    Matcher matcher = mapFilePattern.matcher(line);
                    if (matcher.matches()) {
                        try {
                            FQANPattern fqanPattern = new FQANPattern(matcher.group(1));
                            String oldValue = this.fqanTable.put(fqanPattern, matcher.group(2));
                            logger.debug((Object)("Registered \"" + fqanPattern + "\""));
                            if (oldValue != null) {
                                logger.warn((Object)("Replaced value for " + matcher.group(1) + ": " + oldValue));
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            logger.debug((Object)ex.getMessage());
                        }
                    }
                    line = reader.readLine();
                }
                Object var8_9 = null;
                if (reader == null) return;
            }
            catch (IOException ioEx) {
                logger.error((Object)ioEx.getMessage(), (Throwable)ioEx);
                throw new InitializeException(ioEx.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        reader.close();
        return;
    }

    private int checkList(List<VOMSAttribute> vomsList) {
        Iterator<VOMSAttribute> vIter = vomsList.iterator();
        while (vIter.hasNext()) {
            List fqanList = vIter.next().getFullyQualifiedAttributes();
            for (String fqanStr : fqanList) {
                for (FQANPattern pattern : this.fqanTable.keySet()) {
                    logger.debug((Object)("Checking fqan: " + fqanStr + " against " + pattern.toString()));
                    if (!pattern.matches(fqanStr)) continue;
                    logger.info((Object)("VOMS attribute authorized: " + fqanStr));
                    return 2;
                }
            }
        }
        return 1;
    }

    private void logMessageForFQAN(List<VOMSAttribute> vomsList, String msg) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(msg + " with fqan list ["));
            Iterator<VOMSAttribute> vIter = vomsList.iterator();
            while (vIter.hasNext()) {
                List fqanList = vIter.next().getFullyQualifiedAttributes();
                Iterator fqanIter = fqanList.iterator();
                while (fqanIter.hasNext()) {
                    logger.debug((Object)("    " + (String)fqanIter.next()));
                }
            }
            logger.debug((Object)"]");
        }
    }

    @Override
    public int getPermissionLevel(Subject peerSubject, ServiceAuthorizationInterface.MessageContext context, QName operation) throws AuthorizationException {
        List vomsList = (List)context.getProperty("user.vomsattrs");
        if (vomsList != null && vomsList.size() > 0) {
            logger.debug((Object)"Found VOMS attribute list in the message context");
            return this.checkList(vomsList);
        }
        logger.debug((Object)"No VOMS attribute list in the message context, trying to parse proxy");
        Set<Object> certChainSet = peerSubject.getPublicCredentials();
        for (Object tmpo : certChainSet) {
            ACValidator acValidator;
            X509Certificate[] certChain;
            VOMSValidator vv;
            if (!(tmpo instanceof X509Certificate[]) || (vomsList = (vv = new VOMSValidator(certChain = (X509Certificate[])tmpo, acValidator = AuthorizationModule.getACValidator()).validate()).getVOMSAttributes()) == null || vomsList.size() <= 0 || this.checkList(vomsList) != 2) continue;
            context.setProperty("user.vomsattrs", vomsList);
            return 2;
        }
        if (vomsList != null && vomsList.size() > 0) {
            this.logMessageForFQAN(vomsList, "Authorization failed");
        }
        return 1;
    }

    @Override
    public void close() throws CloseException {
    }

    @Override
    public Object clone() {
        VomsServicePDP result = new VomsServicePDP(this.id);
        result.gridMapFile = this.gridMapFile;
        result.timestamp = this.timestamp;
        result.fqanTable = (HashMap)this.fqanTable.clone();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VomsServicePDP)) {
            return false;
        }
        VomsServicePDP pdp = (VomsServicePDP)obj;
        return pdp.gridMapFile.equals(this.gridMapFile) && pdp.id.equals(this.id) && pdp.timestamp == this.timestamp;
    }
}

