/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.gjaf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.authz.AuthorizationException;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.gjaf.ChainConfig;
import org.glite.ce.commonj.authz.gjaf.InitializeException;
import org.glite.ce.commonj.authz.gjaf.InterceptorConfig;
import org.glite.ce.commonj.authz.gjaf.ServiceInterceptor;
import org.glite.ce.commonj.authz.gjaf.ServicePDP;
import org.glite.ce.commonj.authz.gjaf.ServicePIP;
import org.glite.ce.commonj.configuration.CEConfigResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAuthorizationChain
implements ServiceAuthorizationInterface,
CEConfigResource {
    public static final long serialVersionUID = 1318326624L;
    private static Logger logger = Logger.getLogger((String)ServiceAuthorizationChain.class.getName());
    private String id;
    private ServiceInterceptor[] interceptor;

    public synchronized void initialize(ChainConfig config, String name, String id) throws InitializeException {
        this.id = id;
        ClassLoader loader = this.getClass().getClassLoader();
        InterceptorConfig[] interceptorConfig = config.getInterceptors();
        if (interceptorConfig == null) {
            throw new InitializeException("No interceptor in configuration");
        }
        this.interceptor = new ServiceInterceptor[interceptorConfig.length];
        try {
            for (int i = 0; i < interceptorConfig.length; ++i) {
                if (interceptorConfig[i].isLoaded()) {
                    this.interceptor[i] = interceptorConfig[i].getInterceptor();
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to load: " + interceptorConfig[i].getInterceptorClass()));
                }
                Class<?> interceptorClass = loader.loadClass(interceptorConfig[i].getInterceptorClass());
                this.interceptor[i] = (ServiceInterceptor)interceptorClass.newInstance();
                this.interceptor[i].initialize(config, interceptorConfig[i].getName(), id);
            }
        }
        catch (InitializeException initEx) {
            throw initEx;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new InitializeException("Cannot load interceptor chain", e);
        }
    }

    public synchronized void initialize(String id, List<ServiceInterceptor> interceptorList) {
        this.id = id;
        this.interceptor = new ServiceInterceptor[interceptorList.size()];
        interceptorList.toArray(this.interceptor);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isPermitted(Subject peerSubject, ServiceAuthorizationInterface.MessageContext context, QName operation) throws AuthorizationException {
        try {
            Set<X500Principal> pSet = peerSubject.getPrincipals(X500Principal.class);
            String peerIdentity = pSet.size() > 0 ? pSet.iterator().next().toString() : "unknown";
            int level = 0;
            for (int i = 0; this.interceptor != null && i < this.interceptor.length; ++i) {
                if (this.interceptor[i] instanceof ServicePDP) {
                    ServicePDP pdp = (ServicePDP)this.interceptor[i];
                    level |= pdp.getPermissionLevel(peerSubject, context, operation);
                    continue;
                }
                if (!(this.interceptor[i] instanceof ServicePIP)) continue;
                ((ServicePIP)this.interceptor[i]).collectAttributes(peerSubject, context, operation);
            }
            if (level < 2) {
                logger.info((Object)("User " + peerIdentity + " not authorized for " + operation));
                return false;
            }
            if (level < 4) {
                logger.debug((Object)("User " + peerIdentity + " authorized for " + operation));
                return true;
            }
            if (level < 8) {
                logger.info((Object)("User " + peerIdentity + " not authorized for " + operation));
                return false;
            }
            logger.debug((Object)("User " + peerIdentity + " authorized for " + operation));
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new AuthorizationException("Authorization error: " + ex.getMessage(), ex);
        }
    }

    public ServiceInterceptor[] getInterceptors() {
        return this.interceptor;
    }

    public File[] getAllTriggers() {
        ArrayList<File> tmpList = new ArrayList<File>(this.interceptor.length);
        for (int k = 0; k < this.interceptor.length; ++k) {
            String[] props = this.interceptor[k].getProperties();
            for (int j = 0; j < props.length; ++j) {
                if (!this.interceptor[k].isTriggerable(props[j])) continue;
                tmpList.add(new File(this.interceptor[k].getProperty(props[j])));
            }
        }
        File[] result = new File[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    @Override
    public Object clone() {
        ServiceAuthorizationChain result = new ServiceAuthorizationChain();
        result.id = this.id;
        result.interceptor = new ServiceInterceptor[this.interceptor.length];
        for (int k = 0; k < this.interceptor.length; ++k) {
            result.interceptor[k] = (ServiceInterceptor)this.interceptor[k].clone();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceAuthorizationChain)) {
            return false;
        }
        ServiceAuthorizationChain chain = (ServiceAuthorizationChain)obj;
        if (chain.interceptor.length != this.interceptor.length) {
            return false;
        }
        for (int k = 0; k < this.interceptor.length; ++k) {
            if (chain.interceptor[k].equals(this.interceptor[k])) continue;
            return false;
        }
        return true;
    }
}

