/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.gjaf;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.glite.ce.commonj.authz.AuthorizationException;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.gjaf.ChainConfig;
import org.glite.ce.commonj.authz.gjaf.CloseException;
import org.glite.ce.commonj.authz.gjaf.InitializeException;
import org.glite.ce.commonj.authz.gjaf.ServicePIP;

public class LocalUserPIP
implements ServicePIP {
    private static final Logger logger = Logger.getLogger((String)LocalUserPIP.class.getName());
    public static final String GLEXEC_BIN_PATH = "glexec_bin_path";
    public static final String GLEXEC_PROBE_CMD = "glexec_probe_cmd";
    public static final String ALLOWED_OPS = "methods";
    public static final Pattern uidPattern = Pattern.compile("uid=\\d+\\(([^)]+)\\)");
    public static final Pattern gidPattern = Pattern.compile("gid=\\d+\\(([^)]+)\\)");
    public static final Pattern groupsPattern = Pattern.compile("groups=(\\S+)");
    public static final Pattern groupsSubPattern = Pattern.compile("\\d+\\(([^)]+)\\)");
    private String id;
    private String glexecPath;
    private String probeCmd;
    private String[] opList;

    public LocalUserPIP() {
        this("undef");
    }

    public LocalUserPIP(String id) {
        this.id = id;
        logger.debug((Object)("Created " + id));
    }

    public void initialize(ChainConfig config, String name, String id) throws InitializeException {
        logger.debug((Object)"Initializing LocalUserPIP");
        this.glexecPath = (String)config.getProperty(name, GLEXEC_BIN_PATH);
        if (this.glexecPath == null) {
            logger.error((Object)"Missing parameter glexec_bin_path");
            throw new InitializeException("Missing parameter glexec_bin_path");
        }
        this.probeCmd = (String)config.getProperty(name, GLEXEC_PROBE_CMD);
        if (this.probeCmd == null) {
            logger.error((Object)"Missing parameter glexec_probe_cmd");
            throw new InitializeException("Missing parameter glexec_probe_cmd");
        }
        String tmps = (String)config.getProperty(name, ALLOWED_OPS);
        if (tmps == null) {
            logger.error((Object)"Missing parameter methods");
            throw new InitializeException("Missing parameter methods");
        }
        this.opList = this.parseOpList(tmps);
        logger.debug((Object)("Initialized LocalUserPIP: " + id));
    }

    public String getId() {
        return this.id;
    }

    public void setProperty(String name, String value) throws InitializeException {
        if (name.equals(GLEXEC_BIN_PATH)) {
            this.glexecPath = value;
        }
        if (name.equals(GLEXEC_PROBE_CMD)) {
            this.probeCmd = value;
        }
        if (name.equals(ALLOWED_OPS)) {
            this.opList = this.parseOpList(value);
        }
    }

    public String getProperty(String name) {
        if (name.equals(GLEXEC_BIN_PATH)) {
            return this.glexecPath;
        }
        if (name.equals(GLEXEC_PROBE_CMD)) {
            return this.probeCmd;
        }
        if (name.equals(ALLOWED_OPS)) {
            StringBuffer buffer = new StringBuffer();
            for (int k = 0; k < this.opList.length; ++k) {
                if (k == 0) {
                    buffer.append(this.opList[k]);
                    continue;
                }
                buffer.append(",").append(this.opList[k]);
            }
            return buffer.toString();
        }
        return null;
    }

    public String[] getProperties() {
        return new String[]{GLEXEC_BIN_PATH, GLEXEC_PROBE_CMD, ALLOWED_OPS};
    }

    public boolean isTriggerable(String name) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void collectAttributes(Subject peerSubject, ServiceAuthorizationInterface.MessageContext context, QName operation) throws AuthorizationException {
        String failureDescr;
        block93: {
            IOException ioEx322;
            BufferedReader err;
            FilterOutputStream out;
            BufferedReader in;
            File tmpFile;
            block87: {
                block86: {
                    boolean missing = true;
                    for (String tmps : this.opList) {
                        missing = missing && !tmps.equals(operation.getLocalPart());
                    }
                    if (missing) {
                        logger.debug((Object)("Operation not enabled: " + operation.getLocalPart()));
                        return;
                    }
                    X509Certificate[] certList = (X509Certificate[])context.getProperty("user.certificate.chain");
                    if (certList == null) {
                        logger.error((Object)"Cannot retrieve proxy certificate from context");
                        throw new AuthorizationException("Cannot retrieve proxy certificate from context");
                    }
                    tmpFile = null;
                    BufferedWriter tmpFileWriter = null;
                    try {
                        tmpFile = File.createTempFile("userproxy", ".pem");
                        tmpFileWriter = new BufferedWriter(new FileWriter(tmpFile));
                        for (X509Certificate certItem : certList) {
                            byte[] pemBytes = Base64.encode((byte[])certItem.getEncoded());
                            tmpFileWriter.write("-----BEGIN CERTIFICATE-----");
                            tmpFileWriter.newLine();
                            for (int n = 0; n < pemBytes.length; n += 64) {
                                if (pemBytes.length - n < 64) {
                                    tmpFileWriter.write(new String(pemBytes, n, pemBytes.length - n));
                                } else {
                                    tmpFileWriter.write(new String(pemBytes, n, 64));
                                }
                                tmpFileWriter.newLine();
                            }
                            tmpFileWriter.write("-----END CERTIFICATE-----");
                            tmpFileWriter.newLine();
                            tmpFileWriter.flush();
                        }
                        logger.debug((Object)("Created temporary proxy " + tmpFile.getAbsolutePath()));
                    }
                    catch (Throwable th) {
                        logger.error((Object)"Cannot store proxy certificate", th);
                        throw new AuthorizationException("Cannot store proxy certificate");
                    }
                    finally {
                        if (tmpFileWriter != null) {
                            try {
                                tmpFileWriter.close();
                            }
                            catch (IOException ioEx2) {
                                logger.error((Object)ioEx2.getMessage(), (Throwable)ioEx2);
                            }
                        }
                    }
                    int retcod = 0;
                    Process chmodProc = null;
                    String chmodCmd = "chmod 0600 " + tmpFile.getAbsolutePath();
                    try {
                        chmodProc = Runtime.getRuntime().exec(chmodCmd);
                        retcod = chmodProc.waitFor();
                    }
                    catch (InterruptedException e) {
                        logger.warn((Object)("Interrupted call to " + chmodCmd));
                        retcod = -1;
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Cannot set permissions to the store proxy certificate", (Throwable)ex);
                        retcod = -1;
                    }
                    finally {
                        if (chmodProc != null) {
                            try {
                                chmodProc.getInputStream().close();
                            }
                            catch (IOException e) {
                                logger.error((Object)("Cannot close instream for " + chmodCmd));
                            }
                            try {
                                chmodProc.getErrorStream().close();
                            }
                            catch (IOException e) {
                                logger.error((Object)("Cannot close errstream for " + chmodCmd));
                            }
                            try {
                                chmodProc.getOutputStream().close();
                            }
                            catch (IOException e) {
                                logger.error((Object)("Cannot close outstream for " + chmodCmd));
                            }
                        }
                    }
                    if (retcod != 0) {
                        throw new AuthorizationException("Cannot set permissions to the store proxy certificate");
                    }
                    String[] envp = new String[]{"GLEXEC_MODE=lcmaps_get_account", "GLEXEC_CLIENT_CERT=" + tmpFile.getAbsolutePath()};
                    String[] cmdLine = new String[]{this.glexecPath, this.probeCmd};
                    in = null;
                    out = null;
                    err = null;
                    failureDescr = null;
                    Process proc = Runtime.getRuntime().exec(cmdLine, envp);
                    in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    out = new BufferedOutputStream(proc.getOutputStream());
                    err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    proc.waitFor();
                    if (proc.exitValue() != 0) {
                        StringBuffer buff = new StringBuffer("glexec error: ");
                        String line = err.readLine();
                        while (line != null) {
                            buff.append(line);
                            line = err.readLine();
                        }
                        failureDescr = buff.toString();
                        logger.error((Object)failureDescr);
                        break block86;
                    }
                    String tmpDN = (String)context.getProperty("user.dn.RFC2253");
                    UserInfo userInfo = this.parseGlexecOutput(in);
                    if (userInfo.uid == null) {
                        logger.warn((Object)("Cannot retrieve user ID from glexec output for: " + tmpDN));
                    } else {
                        logger.debug((Object)("Mapped " + tmpDN + " into " + userInfo.uid));
                        context.setProperty("local.user.id", userInfo.uid);
                    }
                    if (userInfo.gid == null) {
                        logger.warn((Object)("Cannot retrieve group ID from glexec output for: " + tmpDN));
                    } else {
                        logger.debug((Object)("Gid for " + tmpDN + ": " + userInfo.gid));
                        context.setProperty("local.group.id", userInfo.gid);
                    }
                    if (userInfo.groups.size() <= 0) break block86;
                    String[] tmpgrp = new String[userInfo.groups.size()];
                    userInfo.groups.toArray(tmpgrp);
                    context.setProperty("local.groups.list", tmpgrp);
                }
                Object var22_49 = null;
                if (in == null) break block87;
                try {
                    in.close();
                }
                catch (IOException ioEx322) {
                    logger.error((Object)ioEx322.getMessage(), (Throwable)ioEx322);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioEx322) {
                    logger.error((Object)ioEx322.getMessage(), (Throwable)ioEx322);
                }
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (IOException ioEx322) {
                    logger.error((Object)ioEx322.getMessage(), (Throwable)ioEx322);
                }
            }
            if (tmpFile != null && !tmpFile.delete()) {
                logger.error((Object)("Cannot delete file " + tmpFile.getAbsolutePath()));
            }
            break block93;
            {
                catch (Throwable th) {
                    IOException ioEx322;
                    logger.error((Object)th.getMessage(), th);
                    failureDescr = th.getMessage();
                    Object var22_50 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioEx322) {
                            logger.error((Object)ioEx322.getMessage(), (Throwable)ioEx322);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioEx322) {
                            logger.error((Object)ioEx322.getMessage(), (Throwable)ioEx322);
                        }
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (IOException ioEx322) {
                            logger.error((Object)ioEx322.getMessage(), (Throwable)ioEx322);
                        }
                    }
                    if (tmpFile != null && !tmpFile.delete()) {
                        logger.error((Object)("Cannot delete file " + tmpFile.getAbsolutePath()));
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ioEx322;
                Object var22_51 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioEx322) {
                        logger.error((Object)ioEx322.getMessage(), (Throwable)ioEx322);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioEx322) {
                        logger.error((Object)ioEx322.getMessage(), (Throwable)ioEx322);
                    }
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (IOException ioEx322) {
                        logger.error((Object)ioEx322.getMessage(), (Throwable)ioEx322);
                    }
                }
                if (tmpFile != null && !tmpFile.delete()) {
                    logger.error((Object)("Cannot delete file " + tmpFile.getAbsolutePath()));
                }
                throw throwable;
            }
        }
        if (failureDescr != null) {
            throw new AuthorizationException("Failed to get the local user id via glexec: " + failureDescr);
        }
    }

    public void close() throws CloseException {
    }

    public Object clone() {
        LocalUserPIP result = new LocalUserPIP(this.id);
        result.glexecPath = this.glexecPath;
        result.probeCmd = this.probeCmd;
        result.opList = this.opList;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalUserPIP)) {
            return false;
        }
        LocalUserPIP pip = (LocalUserPIP)obj;
        return this.id.equals(pip.id);
    }

    private String[] parseOpList(String opStr) {
        StringTokenizer strok = new StringTokenizer(opStr, ",");
        ArrayList<String> tmpList = new ArrayList<String>();
        while (strok.hasMoreTokens()) {
            String tmps = strok.nextToken().trim();
            if (tmps.length() <= 0) continue;
            tmpList.add(tmps);
            logger.debug((Object)("Registered allowed operation " + tmps));
        }
        String[] result = new String[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    private UserInfo parseGlexecOutput(BufferedReader reader) throws IOException {
        UserInfo result = new UserInfo();
        String line = reader.readLine();
        while (line != null) {
            Matcher groupMatcher;
            Matcher gidMatcher;
            Matcher uidMatcher = uidPattern.matcher(line);
            if (uidMatcher.find()) {
                result.uid = uidMatcher.group(1);
            }
            if ((gidMatcher = gidPattern.matcher(line)).find()) {
                result.gid = gidMatcher.group(1);
            }
            if ((groupMatcher = groupsPattern.matcher(line)).find()) {
                String grpStr = groupMatcher.group(1);
                groupMatcher = groupsSubPattern.matcher(grpStr);
                while (groupMatcher.find()) {
                    String tmps = groupMatcher.group(1);
                    result.groups.add(tmps);
                }
            }
            line = reader.readLine();
        }
        if (result.groups.size() == 0) {
            result.groups.add(result.gid);
        }
        return result;
    }

    private class UserInfo {
        public String uid = null;
        public String gid = null;
        public ArrayList<String> groups = new ArrayList(1);
    }
}

