/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.gjaf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.authz.AuthorizationException;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.gjaf.ChainConfig;
import org.glite.ce.commonj.authz.gjaf.CloseException;
import org.glite.ce.commonj.authz.gjaf.InitializeException;
import org.glite.ce.commonj.authz.gjaf.ServicePDP;
import org.glite.security.util.X500Principal;

public class BlackListServicePDP
implements ServicePDP {
    private static Logger logger = Logger.getLogger((String)BlackListServicePDP.class.getName());
    public static final String BLACK_LIST_FILE = "blackListFile";
    private String id;
    private String blackListFile;
    private HashSet<String> dnTable;
    private long timestamp;

    public BlackListServicePDP() {
        this.id = "undef";
        this.timestamp = 0L;
    }

    public BlackListServicePDP(String id) {
        this.id = id;
        this.timestamp = 0L;
    }

    public void initialize(ChainConfig config, String name, String id) throws InitializeException {
        String bannerFile = (String)config.getProperty(name, BLACK_LIST_FILE);
        if (bannerFile == null) {
            logger.error((Object)"Blacklist file not specified");
            throw new InitializeException("Blacklist file not specified");
        }
        this.readBannerFile(bannerFile);
        this.blackListFile = bannerFile;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setProperty(String name, String value) throws InitializeException {
        if (name.equals(BLACK_LIST_FILE)) {
            this.readBannerFile(value);
            this.blackListFile = value;
        }
    }

    public String getProperty(String name) {
        if (name.equals(BLACK_LIST_FILE)) {
            return this.blackListFile;
        }
        return null;
    }

    public String[] getProperties() {
        return new String[]{BLACK_LIST_FILE};
    }

    public boolean isTriggerable(String name) {
        return name.equals(BLACK_LIST_FILE);
    }

    private void readBannerFile(String bannerFile) throws InitializeException {
        logger.debug((Object)("Initializing blacklist service PDP with " + bannerFile));
        this.dnTable = new HashSet();
        this.timestamp = System.currentTimeMillis();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(bannerFile));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    if (line.startsWith("\"")) {
                        line = line.substring(1);
                    }
                    if (line.endsWith("\"")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    this.dnTable.add(line);
                    logger.debug((Object)("Registered DN: " + line));
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioEx) {
            logger.error((Object)ioEx.getMessage(), (Throwable)ioEx);
            throw new InitializeException(ioEx.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public int getPermissionLevel(Subject peerSubject, ServiceAuthorizationInterface.MessageContext context, QName operation) throws AuthorizationException {
        Set<X500Principal> pSet = peerSubject.getPrincipals(X500Principal.class);
        if (pSet == null) {
            logger.warn((Object)"Cannot authorize: missing X500Principal in subject");
            return 0;
        }
        Iterator<X500Principal> allPrincipals = pSet.iterator();
        while (allPrincipals.hasNext()) {
            String identity = allPrincipals.next().getName();
            logger.debug((Object)("Checking identity: " + identity));
            if (!this.dnTable.contains(identity)) continue;
            logger.info((Object)("Identity banned: " + identity));
            return 4;
        }
        return 0;
    }

    public void close() throws CloseException {
    }

    public Object clone() {
        BlackListServicePDP result = new BlackListServicePDP(this.id);
        result.id = this.id;
        result.blackListFile = this.blackListFile;
        result.timestamp = this.timestamp;
        result.dnTable = (HashSet)this.dnTable.clone();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlackListServicePDP)) {
            return false;
        }
        BlackListServicePDP pdp = (BlackListServicePDP)obj;
        return pdp.blackListFile.equals(this.blackListFile) && pdp.id.equals(this.id) && pdp.timestamp == this.timestamp;
    }
}

