/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.gjaf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.authz.AuthorizationException;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.gjaf.ChainConfig;
import org.glite.ce.commonj.authz.gjaf.CloseException;
import org.glite.ce.commonj.authz.gjaf.InitializeException;
import org.glite.ce.commonj.authz.gjaf.ServicePIP;

public class AdminCheckerPIP
implements ServicePIP {
    private static Logger logger = Logger.getLogger((String)AdminCheckerPIP.class.getName());
    public static final String ADMIN_FILE = "adminList";
    private String id;
    private String adminFile;
    private HashSet<String> dnTable;
    private long timestamp;

    public AdminCheckerPIP() {
        this.id = "undef";
        this.timestamp = 0L;
    }

    public AdminCheckerPIP(String id) {
        this.id = id;
        this.timestamp = 0L;
    }

    public AdminCheckerPIP(String id, String adminFile) throws InitializeException {
        this.id = id;
        this.timestamp = 0L;
        if (adminFile == null) {
            logger.error((Object)"Admin file not specified");
            throw new InitializeException("Admin file not specified");
        }
        this.readAdminFile(adminFile);
    }

    public void initialize(ChainConfig config, String name, String id) throws InitializeException {
        String admFile = (String)config.getProperty(name, ADMIN_FILE);
        if (admFile == null) {
            logger.error((Object)"Admin file not specified");
            throw new InitializeException("Admin file not specified");
        }
        this.readAdminFile(admFile);
        this.adminFile = admFile;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setProperty(String name, String value) throws InitializeException {
        if (name.equals(ADMIN_FILE)) {
            this.readAdminFile(value);
            this.adminFile = value;
        }
    }

    public String getProperty(String name) {
        if (name.equals(ADMIN_FILE)) {
            return this.adminFile;
        }
        return null;
    }

    public String[] getProperties() {
        return new String[]{ADMIN_FILE};
    }

    public boolean isTriggerable(String name) {
        return name.equals(ADMIN_FILE);
    }

    private void readAdminFile(String admFile) throws InitializeException {
        logger.debug((Object)("Initializing admin service PIP with " + admFile));
        this.dnTable = new HashSet();
        this.timestamp = System.currentTimeMillis();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(admFile));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    if (line.startsWith("\"") && line.endsWith("\"")) {
                        line = line.substring(1, line.length() - 1);
                    }
                    this.dnTable.add(line);
                    logger.debug((Object)("Registered DN: " + line));
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioEx) {
            logger.error((Object)ioEx.getMessage(), (Throwable)ioEx);
            throw new InitializeException(ioEx.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void collectAttributes(Subject peerSubject, ServiceAuthorizationInterface.MessageContext context, QName operation) throws AuthorizationException {
        String dn = null;
        try {
            dn = (String)context.getProperty("user.dn.X500");
        }
        catch (ClassCastException ccEx) {
            logger.error((Object)ccEx.getMessage());
        }
        if (dn == null) {
            logger.debug((Object)"USERDN_X500_LABEL undefined in context");
            Set<Principal> set = peerSubject.getPrincipals();
            if (set == null || set.size() < 1) {
                throw new AuthorizationException("Cannot retrieve principals from subject");
            }
            dn = set.iterator().next().getName();
        }
        if (dn == null) {
            logger.error((Object)"Cannot retrieve user DN");
            throw new AuthorizationException("Cannot retrieve user DN");
        }
        Boolean isAdmin = new Boolean(this.dnTable.contains(dn));
        logger.debug((Object)("Admin test for " + dn + ": " + isAdmin));
        context.setProperty("IS_ADMIN", isAdmin);
    }

    public void close() throws CloseException {
    }

    public Object clone() {
        AdminCheckerPIP result = new AdminCheckerPIP(this.id);
        result.id = this.id;
        result.adminFile = this.adminFile;
        result.timestamp = this.timestamp;
        result.dnTable = (HashSet)this.dnTable.clone();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AdminCheckerPIP)) {
            return false;
        }
        AdminCheckerPIP pip = (AdminCheckerPIP)obj;
        return pip.adminFile.equals(this.adminFile) && pip.id.equals(this.id) && pip.timestamp == this.timestamp;
    }
}

