/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.argus;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.glite.authz.common.security.PEMFileReader;
import org.glite.authz.pep.client.config.PEPClientConfiguration;
import org.glite.authz.pep.client.config.PEPClientConfigurationException;
import org.glite.ce.commonj.authz.ServiceAuthorizationFactory;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.argus.ArgusPEP;
import org.glite.ce.commonj.configuration.CEConfigResource;
import org.glite.security.util.FileCertReader;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIStoreFactory;
import org.glite.voms.VOMSTrustManager;

public class PEPConfigurationItem
extends PEPClientConfiguration
implements CEConfigResource,
ServiceAuthorizationFactory {
    static final long serialVersionUID = 1272456581L;
    private static Logger logger = Logger.getLogger((String)PEPConfigurationItem.class.getName());
    private static ServiceAuthorizationInterface pepClient = null;
    private static PEPConfigurationItem currentConfig = null;
    private String userCert;
    private String userKey;
    private String pwd;
    private String caDir;
    private String mapClass;
    private String resID;
    private X509TrustManager pepTrustManager;
    private X509KeyManager pepKeyManager;

    public void setMappingClass(String mClass) {
        this.mapClass = new String(mClass);
    }

    public String getMappingClass() {
        return new String(this.mapClass);
    }

    public void setResourceID(String resID) {
        this.resID = new String(resID);
    }

    public String getResourceID() {
        return new String(this.resID);
    }

    public void setKeyMaterial(String userCert, String userKey, String pwd) throws PEPClientConfigurationException {
        this.userCert = new String(userCert);
        this.userKey = new String(userKey);
        this.pwd = new String(pwd);
        try {
            PEMFileReader reader = new PEMFileReader();
            PrivateKey pkey = reader.readPrivateKey(userKey, pwd);
            Vector certsVector = new FileCertReader().readCerts(userCert);
            Object[] certs = new X509Certificate[certsVector.size()];
            certsVector.copyInto(certs);
            char[] passwd = pwd.toCharArray();
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(null, passwd);
            keystore.setKeyEntry("keycreds", pkey, passwd, (Certificate[])certs);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keystore, passwd);
            this.pepKeyManager = (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new PEPClientConfigurationException(ex);
        }
    }

    public X509KeyManager getKeyManager() {
        return this.pepKeyManager;
    }

    public void setTrustMaterial(String caDir) throws PEPClientConfigurationException {
        this.caDir = new String(caDir);
        try {
            PKIStore trustStore = PKIStoreFactory.getStore((String)caDir, (int)2);
            this.pepTrustManager = new VOMSTrustManager(trustStore);
        }
        catch (Exception ex) {
            throw new PEPClientConfigurationException(ex);
        }
    }

    public X509TrustManager getTrustManager() {
        return this.pepTrustManager;
    }

    public String getCADir() {
        return this.caDir;
    }

    public Object clone() {
        try {
            PEPConfigurationItem res = new PEPConfigurationItem();
            res.setMappingClass(this.mapClass);
            res.setResourceID(this.resID);
            for (String tmps : this.getPEPDaemonEndpoints()) {
                res.addPEPDaemonEndpoint(tmps);
            }
            res.userCert = this.userCert;
            res.userKey = this.userKey;
            res.pwd = this.pwd;
            res.pepKeyManager = this.pepKeyManager;
            res.caDir = this.caDir;
            res.pepTrustManager = this.pepTrustManager;
            res.setConnectionTimeout(this.getConnectionTimeout());
            res.setMaxConnectionsPerHost(this.getMaxConnectionsPerHost());
            res.setMaxTotalConnections(this.getMaxTotalConnections());
            return res;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PEPConfigurationItem)) {
            return false;
        }
        PEPConfigurationItem tmpItem = (PEPConfigurationItem)obj;
        if (!(tmpItem.userCert.equals(this.userCert) && tmpItem.userKey.equals(this.userKey) && tmpItem.pwd.equals(this.pwd))) {
            return false;
        }
        if (!(tmpItem.caDir.equals(this.caDir) && tmpItem.mapClass.equals(this.mapClass) && tmpItem.resID.equals(this.resID))) {
            return false;
        }
        if (tmpItem.getConnectionTimeout() != this.getConnectionTimeout()) {
            return false;
        }
        if (tmpItem.getMaxConnectionsPerHost() != this.getMaxConnectionsPerHost()) {
            return false;
        }
        if (tmpItem.getMaxTotalConnections() != this.getMaxTotalConnections()) {
            return false;
        }
        return ((Object)super.getPEPDaemonEndpoints()).equals(tmpItem.getPEPDaemonEndpoints());
    }

    public ServiceAuthorizationInterface getInstance() {
        if (pepClient == null || currentConfig == null || !this.equals(currentConfig)) {
            currentConfig = (PEPConfigurationItem)this.clone();
            try {
                pepClient = new ArgusPEP(currentConfig);
                logger.debug((Object)"Renewed PEP client instance");
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return pepClient;
    }
}

