/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz;

import java.util.regex.Pattern;

public class FQANPattern {
    private String pattern;
    private Pattern group;
    private Pattern role;

    public FQANPattern(String str) throws IllegalArgumentException {
        this.pattern = FQANPattern.canonicalize(str);
        int idx = this.pattern.indexOf("/Role=");
        if (idx < 0) {
            this.group = Pattern.compile("^" + this.pattern.replaceAll("\\*", ".*").replaceAll("\\?", ".") + "$");
            this.role = null;
        } else {
            this.group = Pattern.compile("^" + this.pattern.substring(0, idx).replaceAll("\\*", ".*").replaceAll("\\?", ".") + "$");
            this.role = Pattern.compile("^" + this.pattern.substring(idx).replaceAll("\\*", ".*").replaceAll("\\?", ".") + "$");
        }
    }

    public boolean matches(String str) {
        String tmps = FQANPattern.canonicalize(str);
        String groupStr = null;
        String roleStr = null;
        int idx = tmps.indexOf("/Role=");
        if (idx < 0) {
            groupStr = tmps;
            roleStr = null;
        } else {
            groupStr = tmps.substring(0, idx);
            roleStr = tmps.substring(idx);
        }
        if (this.group.matcher(groupStr).matches()) {
            if (this.role == null) {
                return roleStr == null;
            }
            if (roleStr == null) {
                return false;
            }
            return this.role.matcher(roleStr).matches();
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FQANPattern)) {
            return false;
        }
        return this.pattern.equals(((FQANPattern)obj).pattern);
    }

    public String toString() {
        return new String(this.pattern);
    }

    public static String canonicalize(String in) throws IllegalArgumentException {
        String str = in.trim();
        if (str.length() < 2 || str.charAt(0) != '/') {
            throw new IllegalArgumentException("Malformed FQAN " + str);
        }
        int idx = str.indexOf(47, 1);
        if (idx < 0) {
            idx = str.length();
        }
        if (str.indexOf(61) < idx && str.indexOf(61) > 0) {
            throw new IllegalArgumentException("Malformed FQAN " + str);
        }
        idx = str.indexOf("/Role=NULL");
        if (idx >= 0) {
            str = str.substring(0, idx);
        } else {
            idx = str.indexOf("Capability");
            if (idx >= 0) {
                str = str.substring(0, idx);
            }
        }
        if (str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

