/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.ceplugin;

import java.util.ArrayList;
import java.util.Hashtable;
import org.glite.ce.ceplugin.CEGlueSchema;
import org.glite.ce.monitorapij.sensor.SensorOutputDataFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISMLDIF
extends SensorOutputDataFormat {
    private String multipleAttributes = "";
    private boolean glue1_2 = false;
    private String timestamp = null;
    private String[] msg = null;

    public ISMLDIF(ArrayList<String> multipleAttributes, boolean glue1_2) {
        super("ISM_LDIF" + (glue1_2 ? "_GLUE_1.2" : ""));
        this.glue1_2 = glue1_2;
        for (int i = 0; i < multipleAttributes.size(); ++i) {
            this.multipleAttributes = this.multipleAttributes + multipleAttributes.get(i) + "\n";
        }
        String[] supportedQueryLang = new String[]{"RegEx", "ClassAd"};
        this.setSupportedQueryLang(supportedQueryLang);
    }

    public String[] apply(Hashtable<String, Object> parameters) throws Exception {
        if (parameters == null) {
            throw new Exception(this.getName() + " apply error: parameter is null");
        }
        String time = (String)parameters.get("timestamp");
        if (this.timestamp == null || !this.timestamp.equals(time)) {
            this.timestamp = time;
            this.msg = null;
        }
        if (this.msg != null) {
            return this.msg;
        }
        String glueSchema = (String)parameters.get("glueSchema");
        if (glueSchema != null) {
            String[] ceinfo = CEGlueSchema.makeCEGlueSchemaInfo(glueSchema, !this.glue1_2);
            this.msg = new String[ceinfo.length + 1];
            this.msg[0] = this.multipleAttributes;
            System.arraycopy(ceinfo, 0, this.msg, 1, ceinfo.length);
            return this.msg;
        }
        throw new Exception(this.getName() + " apply error: glueSchema is null");
    }
}

