/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.ceplugin;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.glite.ce.ceplugin.CEGlueSchema;
import org.glite.ce.monitorapij.sensor.SensorOutputDataFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISMClassAd
extends SensorOutputDataFormat {
    private static final Logger logger = Logger.getLogger((String)ISMClassAd.class.getName());
    private static HashSet<String> ignoreAttributes = new HashSet();
    private static HashSet<String> listAttributes = new HashSet();
    private boolean glue1_2 = false;
    private String timestamp = null;
    private String[] msg = null;

    public ISMClassAd(ArrayList<String> multipleAttributes, boolean glue1_2) {
        super("ISM_CLASSAD" + (glue1_2 ? "_GLUE_1.2" : ""));
        this.glue1_2 = glue1_2;
        String[] supportedQueryLang = new String[]{"RegEx", "ClassAd"};
        this.setSupportedQueryLang(supportedQueryLang);
    }

    public String[] apply(Hashtable<String, Object> parameters) throws Exception {
        if (parameters == null) {
            throw new Exception(this.getName() + " apply error: parameter is null");
        }
        String time = (String)parameters.get("timestamp");
        if (this.timestamp == null || !this.timestamp.equals(time)) {
            this.timestamp = time;
            this.msg = null;
        }
        if (this.msg != null) {
            logger.debug((Object)("Dialect not found: " + this.getName()));
            return this.msg;
        }
        String glueSchema = (String)parameters.get("glueSchema");
        if (glueSchema != null) {
            String[] ceinfo = CEGlueSchema.makeCEGlueSchemaInfo(glueSchema, !this.glue1_2);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < ceinfo.length; ++i) {
                String[] classad = this.ldifToClassad(ceinfo[i]);
                for (int j = 0; j < classad.length; ++j) {
                    result.add(classad[j]);
                }
            }
            this.msg = new String[result.size()];
            this.msg = result.toArray(ceinfo);
            return this.msg;
        }
        throw new Exception(this.getName() + " apply error: glueSchema is null");
    }

    private void parseAttribute(String attr, Hashtable<String, ArrayList<String>> attributeTable, ArrayList<String> glueCESEBindSEList) {
        String[] attribute = attr.split(": ");
        if (attribute != null && attribute.length == 2) {
            String name = attribute[0].trim();
            String value = this.parseAttributeValue(attribute[1]);
            if (ignoreAttributes.contains(name.toLowerCase())) {
                return;
            }
            if (name.startsWith("GlueCESEBind") && glueCESEBindSEList.size() > 0) {
                String cesebind = glueCESEBindSEList.get(glueCESEBindSEList.size() - 1);
                cesebind = cesebind + "\n\t\t\t" + name + " = " + value + ";";
                glueCESEBindSEList.set(glueCESEBindSEList.size() - 1, cesebind);
                return;
            }
            ArrayList<Object> values = null;
            if (attributeTable.containsKey(name)) {
                values = attributeTable.get(name);
            } else {
                values = new ArrayList();
                attributeTable.put(name, values);
            }
            values.add(value);
        }
    }

    private String[] ldifToClassad(String ldif) {
        int index;
        String[] voViews = null;
        if (this.glue1_2 && (index = ldif.indexOf("dn: GlueVOViewLocalID")) > -1) {
            String voView = ldif.substring(index);
            ldif = ldif.substring(0, index);
            voViews = voView.split("\n\n");
        }
        Hashtable<String, ArrayList<String>> ceAttributeTable = this.parseLDIF(ldif);
        ArrayList<Hashtable<String, ArrayList<String>>> voViewList = new ArrayList<Hashtable<String, ArrayList<String>>>();
        ArrayList<Object> ceBaseRuleList = ceAttributeTable.get("GlueCEAccessControlBaseRule");
        HashSet<String> voViewSet = new HashSet<String>();
        for (int i = 0; voViews != null && i < voViews.length; ++i) {
            if (voViews[i] == null || voViews[i].length() == 0) continue;
            Hashtable<String, ArrayList<String>> voTable = this.parseLDIF(voViews[i]);
            ArrayList<String> list = voTable.get("GlueCEAccessControlBaseRule");
            if (list != null) {
                voViewSet.addAll(list);
            }
            voViewList.add(voTable);
        }
        HashSet<Object> ceBaseRuleSet = null;
        ceBaseRuleSet = ceBaseRuleList != null ? new HashSet<String>(ceBaseRuleList) : new HashSet();
        ceBaseRuleSet.removeAll(voViewSet);
        ceBaseRuleList = new ArrayList<Object>(ceBaseRuleSet);
        if (!ceBaseRuleList.isEmpty()) {
            ceAttributeTable.put("GlueCEAccessControlBaseRule", ceBaseRuleList);
        }
        int numberOfClassads = voViewList.size() + (ceBaseRuleSet.size() == 0 ? 0 : 1);
        String[] classadList = null;
        if (numberOfClassads == 0) {
            classadList = new String[]{this.makeClassad(ceAttributeTable)};
        } else {
            int index2 = 0;
            classadList = new String[numberOfClassads];
            if (!ceBaseRuleList.isEmpty()) {
                classadList[index2] = this.makeClassad(ceAttributeTable);
                ++index2;
            }
            for (int i = 0; i < voViewList.size(); ++i) {
                Hashtable voTable = (Hashtable)voViewList.get(i);
                Hashtable ceAttrClone = (Hashtable)ceAttributeTable.clone();
                ceAttrClone.putAll(voTable);
                classadList[index2] = this.makeClassad(ceAttrClone);
                ++index2;
            }
        }
        return classadList;
    }

    private String makeClassad(Hashtable<String, ArrayList<String>> ceAttributeTable) {
        ArrayList<String> glueCESEBindSEList = ceAttributeTable.get("GlueCESEBindSEList");
        StringBuffer classad = new StringBuffer("[\n");
        Enumeration<String> e = ceAttributeTable.keys();
        while (e.hasMoreElements()) {
            String attrName = e.nextElement();
            if (attrName.equals("GlueCESEBindSEList")) continue;
            ArrayList<String> attrValue = ceAttributeTable.get(attrName);
            classad.append("\t").append(attrName).append(" = ");
            if (attrValue.size() > 1 || listAttributes.contains(attrName.toLowerCase())) {
                classad.append("{\n\t\t");
                for (int i = 0; i < attrValue.size(); ++i) {
                    classad.append(attrValue.get(i));
                    classad.append(i < attrValue.size() - 1 ? ",\n\t\t" : " ");
                }
                classad.append("\n\t};\n");
                continue;
            }
            classad.append(attrValue.get(0)).append(";\n");
        }
        if (glueCESEBindSEList != null && !glueCESEBindSEList.isEmpty()) {
            classad.append("\tCloseStorageElements = {\n");
            for (int i = 0; i < glueCESEBindSEList.size(); ++i) {
                String cese = glueCESEBindSEList.get(i);
                if (cese != null) {
                    cese = cese + "\n\t\t\tname = GlueCESEBindSEUniqueID;\n\t\t\tmount = GlueCESEBindCEAccesspoint\n\t\t]";
                }
                classad.append(cese).append(i < glueCESEBindSEList.size() - 1 ? ",\n" : "\n");
            }
            classad.append("\t};\n");
        }
        classad.append("]");
        return classad.toString();
    }

    private Hashtable<String, ArrayList<String>> parseLDIF(String ldif) {
        Hashtable<String, ArrayList<String>> attributeTable = new Hashtable<String, ArrayList<String>>();
        String[] attributes = ldif.split("\n");
        if (attributes == null) {
            return attributeTable;
        }
        ArrayList<String> glueCESEBindSEList = new ArrayList<String>();
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].startsWith("dn: GlueCESEBindSEUniqueID=")) {
                glueCESEBindSEList.add("\t\t[");
            }
            this.parseAttribute(attributes[i], attributeTable, glueCESEBindSEList);
        }
        if (!glueCESEBindSEList.isEmpty()) {
            attributeTable.put("GlueCESEBindSEList", glueCESEBindSEList);
        }
        return attributeTable;
    }

    private String parseAttributeValue(String value) {
        if (value == null) {
            return "undefined";
        }
        String value_lc = value.trim();
        while (value_lc.startsWith(" ")) {
            value_lc = value_lc.substring(1, value_lc.length());
        }
        try {
            Double.parseDouble(value_lc);
            return value_lc;
        }
        catch (NumberFormatException numberFormatException) {
            if (value_lc.equalsIgnoreCase("true") || value_lc.equalsIgnoreCase("false") || value_lc.equalsIgnoreCase("undefined")) {
                return value_lc.toLowerCase();
            }
            value_lc = "\"" + value_lc + "\"";
            return value_lc;
        }
    }

    static {
        ignoreAttributes.add("createtimestamp");
        ignoreAttributes.add("glueschemaversionminor");
        ignoreAttributes.add("glueschemaversionmajor");
        ignoreAttributes.add("entryttl");
        ignoreAttributes.add("modifytimestamp");
        ignoreAttributes.add("dn");
        ignoreAttributes.add("objectclass");
        listAttributes.add("glueforeignkey");
        listAttributes.add("gluesiteotherinfo");
        listAttributes.add("glueclusterservice");
        listAttributes.add("glueceaccesscontrolbaserule");
        listAttributes.add("glueservicecccescontrolbaserule");
        listAttributes.add("glueserviceaccesscontrolrule");
        listAttributes.add("glueserviceowner");
        listAttributes.add("gluehostapplicationsoftwareruntimeenvironment");
    }
}

