/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.ceplugin;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.glite.ce.ceplugin.CESensorEvent;
import org.glite.ce.ceplugin.ISMClassAd;
import org.glite.ce.ceplugin.ISMLDIF;
import org.glite.ce.monitorapij.resource.types.Property;
import org.glite.ce.monitorapij.sensor.AbstractSensor;
import org.glite.ce.monitorapij.sensor.Sensor;
import org.glite.ce.monitorapij.sensor.SensorException;

public class CESensor
extends AbstractSensor {
    private static final long serialVersionUID = 1321622683L;
    private static final Logger logger = Logger.getLogger((String)CESensor.class.getName());
    public static final String SCRIPT_URL_ATTR = "scriptURI";
    public static final String EXEC_DELAY_ATTR = "executionDelay";
    public static final String MULTI_ATTRS_ATTR = "multiple_attributes";
    private String scriptURI;
    private String multipleAttributes;

    public CESensor() throws SensorException {
        super("CE Sensor", "CE_MONITOR");
        StringBuffer buff = new StringBuffer();
        buff.append("GlueChunkKey,");
        buff.append("GlueForeignKey,");
        buff.append("GlueServiceName,");
        buff.append("GlueServiceVersion,");
        buff.append("GlueServiceEndpoint,");
        buff.append("GlueServiceStatusInfo,");
        buff.append("GlueServiceSemantics,");
        buff.append("GlueServiceOwner,");
        buff.append("GlueServiceDataValue,");
        buff.append("GlueSiteName,");
        buff.append("GlueSiteSponsor,");
        buff.append("GlueSiteOtherInfo,");
        buff.append("GlueCEAccessControlBaseRule,");
        buff.append("GlueClusterService,");
        buff.append("GlueHostApplicationSoftwareRunTimeEnvironment,");
        buff.append("GlueHostLocalFileSystemClient,");
        buff.append("GlueHostRemoteFileSystemServer,");
        buff.append("GlueCESEBindGroupSEUniqueID,");
        buff.append("GlueSEHostingSL,");
        buff.append("GlueSEArchitecture,");
        buff.append("GlueSEType,");
        buff.append("GlueSEAccessProtocolSupportedSecurity,");
        buff.append("GlueSEAccessProtocolCapability,");
        buff.append("GlueSEControlProtocolCapability,");
        buff.append("GlueSLServiceGlueSLLocalFileSystemClient,");
        buff.append("GlueSAAccessControlBaseRule");
        buff.append("GlueServiceAccessPointURL");
        buff.append("GlueServiceAccessControlRule");
        buff.append("GlueInformationServiceURL");
        buff.append("GlueHostService");
        buff.append("GlueCESEBindGroupSEUniqueID");
        buff.append("GlueSEHostingSL");
        buff.append("GlueSLService");
        buff.append("GlueSLLocalFileSystemClient");
        this.scriptURI = "/usr/libexec/glite-ce-info";
        this.multipleAttributes = buff.toString();
        Property[] properties = new Property[]{new Property(EXEC_DELAY_ATTR, "60000"), new Property(SCRIPT_URL_ATTR, this.scriptURI), new Property(MULTI_ATTRS_ATTR, this.multipleAttributes)};
        this.setProperty(properties);
        this.setEventOverwriteModeActive(true);
        this.setScope("HIGH");
    }

    public void init() throws SensorException {
        super.init();
        Property scriptURIproperty = this.getProperty(SCRIPT_URL_ATTR);
        this.scriptURI = scriptURIproperty.getValue();
        ArrayList<String> multiAttributesList = new ArrayList<String>();
        Property property = this.getProperty(MULTI_ATTRS_ATTR);
        if (property != null) {
            String mAttrStr = property.getValue();
            if (mAttrStr != null) {
                String[] attributes = mAttrStr.split(",");
                StringBuffer buff = new StringBuffer();
                for (int i = 0; i < attributes.length; ++i) {
                    buff.append(attributes[i]).append("\n");
                    multiAttributesList.add(attributes[i].toLowerCase());
                }
                this.multipleAttributes = buff.toString();
            }
        } else {
            throw new SensorException("Cannot retrieve property multiple_attributes");
        }
        this.addFormat(new ISMClassAd(multiAttributesList, true));
        this.addFormat(new ISMClassAd(multiAttributesList, false));
        this.addFormat(new ISMLDIF(multiAttributesList, true));
        this.addFormat(new ISMLDIF(multiAttributesList, false));
    }

    public void execute() throws SensorException {
        try {
            if (this.scriptURI == null) {
                logger.error((Object)("scriptURI not found: " + this.scriptURI));
                throw new SensorException(0, "scriptURI not found!");
            }
            logger.debug((Object)("Executing " + this.scriptURI));
            Process proc = Runtime.getRuntime().exec(this.scriptURI, null);
            InternalPipeReader outReader = new InternalPipeReader(proc.getInputStream());
            InternalPipeReader errReader = new InternalPipeReader(proc.getErrorStream());
            outReader.start();
            errReader.start();
            proc.waitFor();
            if (proc.exitValue() != 0) {
                logger.error((Object)("Sensor execution failed: " + errReader.getData()));
            } else {
                logger.debug((Object)"Firing sensor event");
                this.fireSensorEvent(new CESensorEvent((Sensor)this, System.currentTimeMillis(), outReader.getData(), this.multipleAttributes));
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new SensorException(0, ex.getMessage());
        }
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"/tmp/log4j.properties");
        String probeScript = args[0];
        try {
            CESensor sensor = new CESensor();
            Property multiAttrProp = sensor.getProperty(MULTI_ATTRS_ATTR);
            Property[] properties = new Property[]{new Property(EXEC_DELAY_ATTR, "60000"), new Property(SCRIPT_URL_ATTR, probeScript), multiAttrProp};
            sensor.setProperty(properties);
            sensor.init();
            sensor.execute();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private class InternalPipeReader
    extends Thread {
        private StringBuffer buffer = new StringBuffer();
        private InputStream inStream;

        public InternalPipeReader(InputStream in) {
            this.inStream = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.inStream));
                String line = reader.readLine();
                while (line != null) {
                    this.buffer.append(line).append("\n");
                    line = reader.readLine();
                }
            }
            catch (Throwable th) {
                logger.error((Object)th.getMessage(), th);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }

        public String getData() {
            this.interrupt();
            return this.buffer.toString();
        }
    }
}

