/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.ceplugin;

import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEGlueSchema {
    private static final Logger logger = Logger.getLogger((String)CEGlueSchema.class.getName());
    public static final int GlueCE = 0;
    public static final int GlueCluster = 1;
    public static final int GlueSubCluster = 2;
    public static final int GlueCESEBindSE = 3;
    public static final int GlueCESEBindGroupCE = 4;
    public static final int GlueVOView = 5;
    public static final String[] keys = new String[]{"GlueCE", "GlueCluster", "GlueSubCluster", "GlueCESEBindSE", "GlueCESEBindGroupCE", "GlueVOView"};

    public static String[] makeCEGlueSchemaInfo(String glueSchema, boolean ignoreGlueVOView) {
        if (glueSchema == null) {
            return null;
        }
        String[] msg = null;
        String[] dn = glueSchema.split("dn");
        ArrayList[] elements = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
        for (int i = 0; i < dn.length; ++i) {
            dn[i] = "dn" + dn[i];
            int type = CEGlueSchema.checkElementType(dn[i]);
            if (type == -1) continue;
            elements[type].add(dn[i]);
        }
        msg = new String[elements[0].size()];
        for (int x = 0; x < elements[0].size(); ++x) {
            String ceInfo = (String)elements[0].get(x);
            try {
                String ceUniqueID = CEGlueSchema.getID(ceInfo, "dn: GlueCEUniqueID", ",").trim();
                String clusterUniqueID = CEGlueSchema.getID(ceInfo, "GlueForeignKey", "\n").trim();
                ArrayList<String> clusterInfo = CEGlueSchema.getElements(elements[1], clusterUniqueID, "GlueClusterUniqueID=", "dn: GlueClusterUniqueID", ",");
                for (int i = 0; i < clusterInfo.size(); ++i) {
                    ceInfo = ceInfo + "\n\n" + clusterInfo.get(i);
                    ArrayList<String> subclusterInfo = CEGlueSchema.getElements(elements[2], clusterUniqueID, "", "GlueChunkKey", "\n");
                    ceInfo = ceInfo + "\n\n" + CEGlueSchema.elementsToString(subclusterInfo);
                }
                ArrayList<String> bindGroupInfo = CEGlueSchema.getElements(elements[4], ceUniqueID, "", "GlueCESEBindGroupCEUniqueID:", "\n");
                ceInfo = ceInfo + "\n\n" + CEGlueSchema.elementsToString(bindGroupInfo);
                ArrayList<String> bindInfo = CEGlueSchema.getElements(elements[3], ceUniqueID, "", "GlueCESEBindCEUniqueID:", "\n");
                ceInfo = ceInfo + "\n\n" + CEGlueSchema.elementsToString(bindInfo);
                if (!ignoreGlueVOView) {
                    ArrayList<String> voView = CEGlueSchema.getElements(elements[5], ceUniqueID, "", "GlueCEUniqueID", ",");
                    ceInfo = ceInfo + "\n\n" + CEGlueSchema.elementsToString(voView);
                }
            }
            catch (Throwable th) {
                logger.error((Object)th.getMessage(), th);
            }
            msg[x] = ceInfo;
        }
        return msg;
    }

    private static String getID(String dn, String key, String delim) throws Exception {
        if (dn == null || key == null) {
            throw new Exception("dn or key is null!");
        }
        int index = dn.indexOf(key);
        if (index > -1) {
            String id = dn.substring(index += key.length() + 1, dn.indexOf(delim, index + 1));
            return id;
        }
        throw new Exception("key " + key + " not found!");
    }

    private static int checkElementType(String dn) {
        for (int i = 0; i < keys.length; ++i) {
            if (!dn.startsWith("dn: " + keys[i] + "UniqueID") && !dn.startsWith("dn: " + keys[i] + "LocalID")) continue;
            return i;
        }
        return -1;
    }

    private static ArrayList<String> getElements(ArrayList<String> elements, String uniqueID, String prefix, String key, String delim) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int y = 0; y < elements.size(); ++y) {
            String info = elements.get(y);
            String id = CEGlueSchema.getID(info, key, delim).trim();
            if (!uniqueID.equals(prefix + id)) continue;
            list.add(info);
        }
        return list;
    }

    private static String elementsToString(ArrayList<String> elements) {
        String result = "";
        if (elements != null) {
            for (int i = 0; i < elements.size(); ++i) {
                String info = elements.get(i);
                if (info == null) continue;
                result = result + "\n\n" + elements.get(i);
            }
        }
        return result;
    }
}

