
## gfal 2.0 tools core logic of mkdir
## @author Adrien Devresse <adevress@cern.ch> CERN
## @license GPLv3
##



import gfal2
import sys
from gfal_tools_arg_parser import *
from gfal_tools_parameters import applys_option
from gfal_tools_verbose import set_verbose_mode
from gfal_tools_errors import gfal_catch_gerror

	
def create_gfal_mkdir_parser():
	p = create_basic_parser()
	p.add_argument("file_uri",type=str, nargs=1)
	return p
	

@gfal_catch_gerror
def gfal_mkdir_main():
	params = create_gfal_mkdir_parser().parse_args(sys.argv[1:])
	set_verbose_mode(params)

	c = gfal2.creat_context()
	applys_option(c,params)
	c.mkdir(params.file_uri[0], 0755)
        return 0



