
## gfal 2.0 tools core save 
## @author Adrien Devresse <adevress@cern.ch> CERN
## @license GPLv3
##


import gfal2
import sys
from gfal2_utils_arg_parser import *
from gfal2_utils_parameters import applys_option
from gfal2_utils_verbose import set_verbose_mode
from gfal2_utils_errors import gfal_catch_gerror


	
def create_gfal_save_parser():
	p = create_basic_parser()
	p.add_argument("file_uri",type=str, nargs=1)
	return p
	
	
def loop_save(f_read, f_write):
	while(True):
		content = f_read()
		if(content):
			f_write(content)
		else:
			return
			
@gfal_catch_gerror
def gfal_save_main():
	params = create_gfal_save_parser().parse_args(sys.argv[1:])
	set_verbose_mode(params)
	def std_readder():
		return sys.stdin.readline()

	c = gfal2.creat_context()
	applys_option(c,params)
	f = c.open(params.file_uri[0], "w")
	def gfal_writer(content):
		f.write(content)

	loop_save(std_readder, gfal_writer)
        return 0



