

## gfal 2.0 tools, args parser 
## @author Adrien Devresse <adevress@cern.ch> CERN
## @license GPLv3
##

import argparse
import sys


# bind simple argument parser
def create_args_parser():
	return argparse.ArgumentParser(prog=sys.argv[0]);


# add generic options for gfal 2 tools
# -> verbose
# -> set/get opts
def create_basic_parser():
	p = create_args_parser()
	p.add_argument( '-v', '--verbose', action='count', default=0, help="enable the verbose mode, -vvv enable debug mode")
	p.add_argument( '-D', '--definition', nargs=1, type=str, help="override a gfal parameter", action='append')	
	return p

