dnl
dnl Define CGSI-GSOAP
dnl
AC_DEFUN([AC_CGSI_GSOAP],
[
	AC_ARG_WITH(cgsi-gsoap-location,
	[  --with-cgsi-gsoap-location=PFX     prefix where CGSI GSOAP plugin is installed. (/opt/cgsi-gsoap)],
	[],
        with_cgsi_gsoap_location=${CGSI_GSOAP_LOCATION:-/usr})
     
	AC_MSG_RESULT([checking for cgsi-gsoap... ])

	if test -n "with_cgsi_gsoap_location" ; then
		CGSI_GSOAP_LOCATION="$with_cgsi_gsoap_location"
		CGSI_GSOAP_CFLAGS="-I$with_cgsi_gsoap_location/include"

        ac_cgsi_gsoap_libdir='lib'
        if test `uname -s` = "Linux"
        then
          # patch linux on power, mips, itanium and intel
          for a in x86_64 powerpc ppc64 mips ia64
          do 
            if test `uname -p` = $a 
            then   
              ac_cgsi_gsoap_libdir='lib64'
            fi 
    
            if test `uname -m` = $a
            then
              ac_cgsi_gsoap_libdir='lib64'
            fi
          done
        fi
    
        # special cases (hyperlink lib64, Debian)
        if test -h /usr/lib64
        then
          ac_cgsi_gsoap_libdir='lib'
        fi
   
        # if /usr/lib64 doesn't exist at all (AIX)
        if ! test -e /usr/lib64
        then
          ac_cgsi_gsoap_libdir='lib'
        fi

        if test `uname -s` = "SunOS"
        then
          if ! test -e /usr/lib/64
          then
            ac_cgsi_gsoap_libdir='lib/64'
          fi
        fi

        ac_cgsi_gsoap_lib="$with_cgsi_gsoap_location/$ac_cgsi_gsoap_libdir"

		ac_cgsi_gsoap_version="gsoap_$GSOAP_MAIN_VERSION"
		
		if test -e /usr/$ac_cgsi_gsoap_libdir/libcgsi_plugin.so; then
			CGSI_GSOAP_LIBS="-L$ac_cgsi_gsoap_lib -lcgsi_plugin"
			CGSI_GSOAP_STATIC_LIBS="$ac_cgsi_gsoap_lib/libcgsi_plugin.a"
			CGSI_GSOAP_CPP_LIBS="-L$ac_cgsi_gsoap_lib -lcgsi_plugin_cpp"
			CGSI_GSOAP_STATIC_CPP_LIBS="$ac_cgsi_gsoap_lib/libcgsi_plugin_cpp.a"
		else
			CGSI_GSOAP_LIBS="-L$ac_cgsi_gsoap_lib -lcgsi_plugin_${ac_cgsi_gsoap_version}"
			CGSI_GSOAP_STATIC_LIBS="$ac_cgsi_gsoap_lib/libcgsi_plugin_${ac_cgsi_gsoap_version}.a"
			CGSI_GSOAP_CPP_LIBS="-L$ac_cgsi_gsoap_lib -lcgsi_plugin_${ac_cgsi_gsoap_version}_cpp"
			CGSI_GSOAP_STATIC_CPP_LIBS="$ac_cgsi_gsoap_lib/libcgsi_plugin_${ac_cgsi_gsoap_version}_cpp.a"		
		fi
    else
		CGSI_GSOAP_LOCATION=""
		CGSI_GSOAP_CFLAGS=""
		CGSI_GSOAP_LIBS=""
		CGSI_GSOAP_STATIC_LIBS=""
		CGSI_GSOAP_CPP_LIBS=""
		CGSI_GSOAP_STATIC_CPP_LIBS=""
    fi
       
    AC_MSG_RESULT([CGSI_GSOAP_LOCATION set to $CGSI_GSOAP_LOCATION])
    AC_MSG_RESULT([CGSI_GSOAP_CFLAGS set to $CGSI_GSOAP_CFLAGS])
    AC_MSG_RESULT([CGSI_GSOAP_LIBS set to $CGSI_GSOAP_LIBS])
    AC_MSG_RESULT([CGSI_GSOAP_STATIC_LIBS set to $CGSI_GSOAP_STATIC_LIBS])
    AC_MSG_RESULT([CGSI_GSOAP_CPP_LIBS set to $CGSI_GSOAP_CPP_LIBS])
    AC_MSG_RESULT([CGSI_GSOAP_STATIC_CPP_LIBS set to $CGSI_GSOAP_STATIC_CPP_LIBS])
    
    AC_SUBST(CGSI_GSOAP_LOCATION)
    AC_SUBST(CGSI_GSOAP_CFLAGS)
    AC_SUBST(CGSI_GSOAP_LIBS)
    AC_SUBST(CGSI_GSOAP_STATIC_LIBS)
    AC_SUBST(CGSI_GSOAP_CPP_LIBS)
    AC_SUBST(CGSI_GSOAP_STATIC_CPP_LIBS)
])
