/*
 * Copyright (c) Members of the EGEE Collaboration. 2009-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <iostream>
#include <vector>
#include <string>

#include "saga/saga.hpp"
#include "saga/saga/sd.hpp"

int main(int argc, char *argv[])
{
  std::string svcFilter = "type='org.glite.lb.server'";
  std::string dataFilter = "glite-info-service_version='1.5'";
  std::string authzFilter = "";

  try
  {
    // Create a Discoverer
    saga::sd::discoverer sd;

    // Use the Discoverer to select services
    std::vector<saga::sd::service_description> services;
    services = sd.list_services(svcFilter, dataFilter, authzFilter);

    std::vector<saga::sd::service_description>::iterator servicesIter;
    std::vector<saga::sd::service_description>::const_iterator
      servicesEnd = services.end();

    for ( servicesIter = services.begin();
        servicesIter != servicesEnd;
        ++servicesIter )
    {
      std::cout << std::endl << "Service Description of "
        << servicesIter->get_url() << std::endl;
      std::cout << "Name: "<< servicesIter->get_attribute("Name")
        << std::endl;
      saga::sd::service_data data;
      data = servicesIter->get_data();

      std::vector<std::string> attribs =
      data.get_vector_attribute("glite-info-service_hostname");
      std::vector<std::string>::const_iterator attribsIter;
      std::vector<std::string>::const_iterator attribsEnd =
      attribs.end();
      for ( attribsIter = attribs.begin(); attribsIter != attribsEnd;
          ++attribsIter )
      {
        std::cout << "glite-info-service_hostname: "
          << *attribsIter << std::endl;
      }

    }
  }

  catch ( saga::exception& e )
  {
    std::cerr << "ERROR: " << e.get_message() << std::endl;
    exit(1);
  }

  return 0;
}
