/*
 * Copyright (c) Members of the EGEE Collaboration. 2009-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <iostream>
#include <vector>
#include <string>

#include "saga/saga.hpp"
#include "saga/saga/sd.hpp"

int main(int argc, char *argv[])
{
   std::string svcFilter = "type='org.glite.lb.server'";
   std::string dataFilter = "glite-info-service_version='1.5'";
   std::string authzFilter = "";

   try
   {
      // Create a Discoverer
      saga::sd::discoverer sd;

      // Use the Discoverer to select services
      std::vector<saga::sd::service_description> services;
      services = sd.list_services(svcFilter, dataFilter, authzFilter);

      // Take the first url
      if (services.size()> 0)
      {
         std::cout << "URL: " << services[0].get_url() << std::endl;
      }
      else
      {
         std::cout << "No matching services found" << std::endl;
      }
   }

   catch ( saga::exception& e )
   {
      std::cerr << "ERROR: " << e.get_message() << std::endl;
      exit(1);
   }

   return 0;
}

