/*
 * Copyright (c) Members of the EGEE Collaboration. 2009-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "saga/saga/isn.hpp"

int main(int argc, char *argv[])
{
  std::string model = "glue1";
  std::string entity_name = "Site";
  std::string filter = "Description='LCG Site'";

  try
  {
    // Create an entity_data_set
    saga::isn::entity_data_set eds(model, entity_name, filter);

    // Extract the data set
    std::vector<saga::isn::entity_data> data_set = eds.get_data();

    std::vector<saga::isn::entity_data>::const_iterator dataIter;
    std::vector<saga::isn::entity_data>::const_iterator
    endIter = data_set.end();

    for ( dataIter = data_set.begin(); dataIter != endIter; ++dataIter )
    {
      std::vector<std::string> attribNames = dataIter->list_attributes();

      std::vector<std::string>::const_iterator attribNamesIter;
      std::vector<std::string>::const_iterator
      attribNamesEnd = attribNames.end();

      for ( attribNamesIter = attribNames.begin();
          attribNamesIter != attribNamesEnd;
          ++attribNamesIter )
      {
        if ( !dataIter->attribute_is_vector(*attribNamesIter) )
        {
          std::string
          attribValue = dataIter->get_attribute(*attribNamesIter);
          std::cout << *attribNamesIter << ": "
          << attribValue << std::endl;
        }

        else
        {
          std::vector<std::string> attribValues =
          dataIter->get_vector_attribute(*attribNamesIter);

          std::vector<std::string>::const_iterator attribValuesIter;
          std::vector<std::string>::const_iterator
          attribValuesEnd = attribValues.end();

          for ( attribValuesIter = attribValues.begin();
              attribValuesIter != attribValuesEnd;
              ++attribValuesIter )
          {
            std::cout << *attribNamesIter << ": "
            << *attribValuesIter << std::endl;
          }
        }
      }
      std::cout << std::endl;
    }
  }
  catch ( saga::exception& e )
  {
    std::cerr << "ERROR: " << e.get_message() << std::endl;
    exit(1);
  }

  return 0;
}
