/*
 * Copyright (c) Members of the EGEE Collaboration. 2009-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "saga/saga/isn.hpp"

int main(int argc, char *argv[])
{
  std::string model = "glue1";
  std::string entity_name = "Site";
  std::string filter = "Description='LCG Site'";

  try
  {
    // Create an entity_data_set
    saga::isn::entity_data_set eds(model, entity_name, filter);

    std::cout << "Selected " << eds.get_entity_count() << " sites" 
      << std::endl;

    std::vector<std::string> rel = eds.list_related_entity_names();
    std::vector<std::string>::const_iterator iter;
    std::vector<std::string>::const_iterator endIter = rel.end();

    std::cout << "Related Enities:"<< std::endl;

    for ( iter = rel.begin(); iter != endIter; ++iter )
    {
      std::cout << "    " << *iter << std::endl;
    }
  }

  catch ( saga::exception& e )
  {
    std::cerr << "ERROR: " << e.get_message() << std::endl;
    exit(1);
  }

  return 0;
}
