CREATE TABLE guid (
      "guid" bytea,
      "si" bytea,
      "reference" char(32),
      "req_delete" bytea,
      "req_migrate" bytea,
      PRIMARY KEY ("guid")
);

INSERT INTO guid ("guid", "si", "reference" ) 
  SELECT DECODE("guid", 'hex'), DECODE ("si", 'hex'), "table_name" FROM guids;

DROP TABLE guids CASCADE;
ALTER TABLE guid RENAME TO guids;

CREATE TABLE replicas_ (
  "guid" bytea REFERENCES guids ON DELETE CASCADE,
  "last_access" TIMESTAMP WITHOUT TIME ZONE,
  "expires" TIMESTAMP WITHOUT TIME ZONE,
  "surl" VARCHAR(256)
);

INSERT INTO replicas_ ("guid", "last_access", "expires", "surl" ) 
  SELECT DECODE("guid", 'hex') , "last_access", "expires", "surl" FROM replicas;

DROP TABLE replicas CASCADE;
ALTER TABLE replicas_ RENAME TO replicas;


CREATE TABLE masterindex_ (
        "id" integer unique,
        "directory" varchar(1024) PRIMARY KEY,
        "table_name" varchar(64),
        "flags" int,
        "main_column" varchar(64),
        "master" varchar(64),
        "owner_name" varchar(64),  
        "permissions" char(3),
        "acls" varchar(2048),
        "rep_groups" varchar(2048),
        "rep_xid" bigint,
        "info" varchar(2048)
);

CREATE TABLE voms_user (
    "subject" varchar(256),
    "name" varchar(64) ,
    PRIMARY KEY ("subject")
);

CREATE TABLE voms_group (
    "subject" varchar(256),
    "name" varchar(64) ,
    PRIMARY KEY ("subject")
);


INSERT INTO masterindex_("id", "directory", "table_name", "flags", 
                        "master", "permissions", "acls", "rep_groups", "rep_xid")
  SELECT "id", "directory", "table_name", 0, "master", "permissions",
         "acls", "rep_groups", "rep_xid"
  FROM masterindex;                   

UPDATE masterindex_ SET flags = 0, table_name = '' WHERE table_name = 'x';
UPDATE masterindex_ SET flags = flags | 1 WHERE table_name ~ '^dir[0-9]+_.*s.*';
UPDATE masterindex_ SET flags = flags | 2 WHERE table_name ~ '^dir[0-9]+_.*a.*';
UPDATE masterindex_ SET flags = flags | 4 WHERE table_name ~ '^dir[0-9]+_.*p.*';
UPDATE masterindex_ SET flags = flags | 8 WHERE table_name ~ '^dir[0-9]+_.*f.*';

UPDATE masterindex_ SET flags = flags | x'2000'::int WHERE table_name ~ 'index_.*';
UPDATE masterindex_ SET flags = flags | x'3000'::int WHERE table_name ~ 'view_.*';
UPDATE masterindex_ SET flags = flags | x'4000'::int WHERE table_name ~ 'sequence_.*';

UPDATE masterindex_ SET flags = flags | 20 WHERE table_name ~ '^[:].*';

UPDATE masterindex_ SET flags = flags | x'1000'::int WHERE flags < 1024;

UPDATE masterindex_ SET flags = flags | 64 WHERE NOT (flags & 4) = 4;

UPDATE masterindex_ SET table_name = substring(table_name from '^dir\\d+') WHERE table_name ~ '^dir\\d+';

UPDATE masterindex_ SET table_name = substring(table_name from 2) WHERE table_name ~ '^[:].*'; 

ALTER TABLE constraints DROP constraint constraints_table_id_fkey;
DROP TABLE masterindex CASCADE;

ALTER TABLE masterindex_ RENAME TO masterindex;
ALTER TABLE constraints ADD constraint constraints_table_id_fkey FOREIGN KEY (table_id) REFERENCES masterindex(id)
       ON DELETE CASCADE;

UPDATE amga SET amga_version = '2.0';

ALTER TABLE sites ADD COLUMN "cert_password" VARCHAR(32);

CREATE OR REPLACE FUNCTION newguid() RETURNS TRIGGER AS '
DECLARE
    temp varchar;
BEGIN
--    RAISE NOTICE ''GUID INSERT TRIGGER CALLED'';
    IF NOT NEW.guid IS NULL THEN
        temp = TG_RELNAME || TG_ARGV[0];
        IF TG_ARGV[0] = ''_s'' THEN
            temp = temp || NEW.dir;
        END IF;
        INSERT INTO guids ("guid", "si", "reference") VALUES (NEW.guid, '''', temp);
    END IF;
    RETURN NULL;
END;
' LANGUAGE plpgsql;


