CREATE TABLE guid (
  "guid" RAW(16),    
  "si" RAW(16),
  "reference" VARCHAR(32),
  "req_delete" RAW(16),
  "req_migrate" RAW(16),   
  PRIMARY KEY ("guid")
);

INSERT INTO guid ("guid", "si", "reference" ) 
  SELECT HEXTORAW("guid"), HEXTORAW("si"), "table_name" FROM guids;

DROP TABLE guids CASCADE CONSTRAINTS;
ALTER TABLE guid RENAME TO guids;

CREATE TABLE replicas_ (
  "guid" RAW(16) references guids ("guid") ON DELETE CASCADE,
  "last_access" TIMESTAMP,
  "expires" TIMESTAMP,
  "surl" VARCHAR(256),
  PRIMARY KEY ("guid")
);

INSERT INTO replicas_ ("guid", "last_access", "expires", "surl" )
  SELECT HEXTORAW("guid"), "last_access", "expires", "surl" FROM replicas;

DROP TABLE replicas CASCADE CONSTRAINTS;
ALTER TABLE replicas_ RENAME TO replicas;


CREATE TABLE masterindex_ (
        "id" integer unique,
        "directory" varchar(1024) PRIMARY KEY,
        "table_name" varchar(64),
        "flags" int,
        "main_column" varchar(64),
        "master" varchar(64),
        "owner_name" varchar(64),  
        "permissions" char(3),
        "acls" varchar(2048),
        "rep_groups" varchar(2048),
        "rep_xid" number(37),
        "info" varchar(2048)
);

CREATE TABLE voms_user (
    "subject" varchar(256),
    "name" varchar(64) ,
    PRIMARY KEY ("subject")
);

CREATE TABLE voms_group (
    "subject" varchar(256),
    "name" varchar(64) ,
    PRIMARY KEY ("subject")
);


INSERT INTO masterindex_("id", "directory", "table_name", "flags", 
                        "master", "permissions", "acls", "rep_groups", "rep_xid")
  SELECT "id", "directory", "table_name", 0, "master", "permissions",
         "acls", "rep_groups", "rep_xid"
  FROM masterindex;                   

CREATE OR replace FUNCTION bitor( x IN NUMBER, y IN NUMBER ) RETURN NUMBER  AS
BEGIN
    RETURN x + y - bitand(x,y);
END;
/

UPDATE masterindex_ SET "flags" = 0, "table_name" = '' WHERE "table_name" = 'x';
UPDATE masterindex_ SET "flags" = BITOR("flags", 1) WHERE REGEXP_LIKE("table_name", '^dir[0-9]+_.*s.*');
UPDATE masterindex_ SET "flags" = BITOR("flags", 2) WHERE REGEXP_LIKE("table_name", '^dir[0-9]+_.*a.*');
UPDATE masterindex_ SET "flags" = BITOR("flags", 4) WHERE REGEXP_LIKE("table_name", '^dir[0-9]+_.*p.*');
UPDATE masterindex_ SET "flags" = BITOR("flags", 8) WHERE REGEXP_LIKE("table_name", '^dir[0-9]+_.*f.*');

UPDATE masterindex_ SET "flags" = BITOR("flags", 8192) WHERE REGEXP_LIKE("table_name", 'index_.*');
UPDATE masterindex_ SET "flags" = BITOR("flags", 12288) WHERE REGEXP_LIKE("table_name", 'view_.*');
UPDATE masterindex_ SET "flags" = BITOR("flags", 16384) WHERE REGEXP_LIKE("table_name", 'sequence_.*');

UPDATE masterindex_ SET "flags" = BITOR("flags", 20) WHERE REGEXP_LIKE("table_name", '^[:].*');
UPDATE masterindex_ SET "flags" = BITOR("flags", 4096) WHERE "flags" < 1024;

UPDATE masterindex_ SET "flags" = BITOR("flags", 64) WHERE bitand("flags", 4) != 4;

SELECT "table_name", REGEXP_SUBSTR("table_name", '^dir[0-9]+') FROM masterindex_ WHERE REGEXP_LIKE("table_name", '^dir[0-9]+');

UPDATE masterindex_ set "owner_name" = 'testframework' WHERE REGEXP_LIKE("directory", '^/users/testframework/.*');

SELECT "directory", "owner_name" from masterindex where REGEXP_LIKE("directory", '^/users/rlambert/.*');       


UPDATE masterindex_ SET "table_name" = REGEXP_SUBSTR("table_name", '^dir[0-9]+') WHERE REGEXP_LIKE("table_name", '^dir[0-9]+');

UPDATE masterindex_ SET "table_name" = SUBSTR("table_name",2) WHERE REGEXP_LIKE("table_name", '^[:].*'); 

DROP TABLE masterindex CASCADE CONSTRAINTS;

ALTER TABLE masterindex_ RENAME TO masterindex;
ALTER TABLE constraints ADD CONSTRAINT constraints_table_id_fkey FOREIGN KEY ("table_id") REFERENCES masterindex("id")
       ON DELETE CASCADE;

UPDATE amga SET "amga_version" = '2.0';

ALTER TABLE sites ADD "cert_password" VARCHAR(32);
