ALTER TABLE guids ADD COLUMN req_delete VARCHAR(32);
ALTER TABLE guids ADD COLUMN req_migrate VARCHAR(32);
ALTER TABLE guids CHANGE COLUMN table_name reference VARCHAR(32);

CREATE TABLE masterindex_ (
        id integer NOT NULL,
        directory varchar(1024),
        table_name varchar(64),
        flags int,
        main_column varchar(64),
        master varchar(64),
        owner_name varchar(64),  
        permissions char(3),
        acls varchar(2048),
        rep_groups varchar(2048),
        rep_xid bigint,
        info varchar(2048),
	PRIMARY KEY(id,directory(256))
) TYPE = InnoDB;

INSERT INTO masterindex_(id, directory, table_name, flags, 
                        master, permissions, acls, rep_groups, rep_xid)
  SELECT id, directory, table_name, 0, master, permissions,
         acls, rep_groups, rep_xid
  FROM masterindex;                   

CREATE TABLE voms_user (
    `subject` TEXT(256),
    `name` VARCHAR(64),
    PRIMARY KEY (`subject`(256))
) ENGINE = InnoDB;

CREATE TABLE voms_group (
    `subject` TEXT(256),
    `name` VARCHAR(64),
    PRIMARY KEY (`subject`(256))
) ENGINE = InnoDB;


UPDATE masterindex_ SET flags = 0, table_name = '' WHERE table_name = 'x';
UPDATE masterindex_ SET flags = flags | 1 WHERE table_name LIKE 'dir%_s';
UPDATE masterindex_ SET flags = flags | 2 WHERE table_name LIKE 'dir%_a';
UPDATE masterindex_ SET flags = flags | 4 WHERE table_name LIKE 'dir%_p';
UPDATE masterindex_ SET flags = flags | 8 WHERE table_name LIKE 'dir%f';

UPDATE masterindex_ SET flags = flags | x'2000' WHERE table_name LIKE '%index_%';
UPDATE masterindex_ SET flags = flags | x'3000' WHERE table_name LIKE '%view_%';
UPDATE masterindex_ SET flags = flags | x'4000' WHERE table_name LIKE '%sequence_%';

UPDATE masterindex_ SET flags = flags | 20 WHERE table_name LIKE ':%';

UPDATE masterindex_ SET flags = flags | x'1000' WHERE flags < 1024;

UPDATE masterindex_ SET flags = flags | 64 WHERE NOT (flags & 4) = 4;

UPDATE masterindex_ SET table_name = substring_index(table_name,'_',1) WHERE table_name LIKE 'dir%_s';
UPDATE masterindex_ SET table_name = substring_index(table_name,'_',1) WHERE table_name LIKE 'dir%_a';
UPDATE masterindex_ SET table_name = substring_index(table_name,'_',1) WHERE table_name LIKE 'dir%_p';
UPDATE masterindex_ SET table_name = substring_index(table_name,'_',1) WHERE table_name LIKE 'dir%_f';

UPDATE masterindex_ SET table_name = substring(table_name from 2) WHERE table_name LIKE ':%'; 

ALTER TABLE constraints DROP FOREIGN KEY constraints_ibfk_1;
DROP TABLE masterindex CASCADE;

ALTER TABLE masterindex_ RENAME TO masterindex;
ALTER TABLE constraints ADD CONSTRAINT constraints_table_id_fkey FOREIGN KEY (`table_id`) REFERENCES masterindex(`id`) ON DELETE CASCADE;

UPDATE amga SET amga_version = '2.0';

ALTER TABLE sites ADD COLUMN cert_password VARCHAR(32);
