/* Table for holding system information */
CREATE TABLE amga (
	"amga_version" varchar(8),
        "amga_node_id" varchar(64)
);
INSERT INTO amga ("amga_version") VALUES ('2.1.1');

/* Main table */
CREATE TABLE masterindex (
	"id" integer unique,
	"directory" varchar(256) PRIMARY KEY,
	"table_name" varchar(64),
	"master" varchar(64),
	"owner_name" varchar(64),
	"permissions" char(3),
	"acls" varchar(2048),
	"rep_groups" varchar(2048),
        "rep_xid" bigint
);
INSERT INTO masterindex ("id", "directory", "table_name", "master", "owner_name", "permissions", "acls", "rep_groups" )
	         VALUES (1, '/', 'x', '', 'root', 'rwx', '|system:anyuser rx|', '');

/* User management */
CREATE TABLE groups (
    "name" varchar(64) PRIMARY KEY,
    "owner" varchar(64),
    "members" varchar(1024)
);

CREATE TABLE users (
    "name" varchar(64) PRIMARY KEY,
    "password" varchar(64), 
    "capabilities" VARCHAR(256)
);

CREATE TABLE certificates (
    "subject" varchar(256),
    "name" varchar(64) REFERENCES users ON DELETE CASCADE,
    PRIMARY KEY ("subject", "name")
);

CREATE TABLE proxy (
    "directory" varchar(1024),
    "mnt_master" varchar(64) ,
    PRIMARY KEY ("directory", "mnt_master")
);

CREATE TABLE voms_user (
    "subject" varchar(256),
    "name" varchar(64) ,
    PRIMARY KEY ("subject")
);

CREATE TABLE voms_group (
    "subject" varchar(256),
    "name" varchar(64) ,
    PRIMARY KEY ("subject")
);


CREATE TABLE constraints (
  "table_id"   integer references masterindex ("id") ON DELETE CASCADE,
  "name"       varchar(64),
  "type"       char(1),
  "column"     varchar(64),
  "constraint" varchar(1024),
  PRIMARY KEY ("table_id", "name")
);


/* Tables for a file catalogue */
CREATE TABLE guids (
  "guid" VARCHAR(32),
  "table_id" INT,
  PRIMARY KEY ("guid")
);
        
CREATE TABLE replicas (
  "guid" VARCHAR(32),  
  "last_access" TIMESTAMP,
  "expires" TIMESTAMP,    
  "surl" VARCHAR(256),     
  PRIMARY KEY ("guid")    
);              


/* Replication: tables used as a slave */
CREATE TABLE masters (
        "mst_id" VARCHAR(64) PRIMARY KEY,
        "mst_state" VARCHAR(16),
        "mst_last_xid" bigint
);

CREATE TABLE mounts (
        "mnt_master" VARCHAR(64) NOT NULL,
        "mnt_directory" VARCHAR(256) PRIMARY KEY,
        "mnt_state" VARCHAR(16),
        "mnt_last_xid" bigint
);

/* The tr_id column gives logs a serial id so they can be ordered*/
CREATE TABLE transactions (
    "tr_id"             INTEGER PRIMARY KEY AUTOINCREMENT,
    "tr_transaction_id" INT,
    "tr_log_directory"  VARCHAR(256),
    "tr_log_cwd"        VARCHAR(256),
    "tr_log_command"    TEXT
);

/* For generating unique numbers global to this AMGA installation.*/
/* CREATE SEQUENCE sequencer CYCLE; */

