

/* Main table */
CREATE TABLE masterindex (
	"id" integer unique,
	"directory" varchar(1024) PRIMARY KEY,
	"table_name" varchar(64),
	"flags" smallint,
	"main_column" varchar(64),
	"master" varchar(64),
	"owner_name" varchar(64),
	"permissions" char(3),
	"acls" varchar(2048),
	"rep_groups" varchar(2048),
	"rep_xid" number(37),
	"info" varchar(2048)
);

INSERT INTO masterindex ("id", "directory", "table_name", "flags", "master", "owner_name", "permissions", "acls", "rep_groups" )
                 VALUES (1, '/', '', 4096, '', 'root', 'rwx', '|system:anyuser rx|', '');
                 
/* User management */
CREATE TABLE groups (
    "name" varchar(64) PRIMARY KEY,
    "owner" varchar(64),
    "members" varchar(1024)
);

CREATE TABLE users (
    "name" varchar(64) PRIMARY KEY,
    "password" varchar(64),
    "capabilities" VARCHAR(256)
);

CREATE TABLE certificates (
    "subject" varchar(256),
    "name" varchar(64) REFERENCES users ON DELETE CASCADE,
    PRIMARY KEY ("subject", "name")
);

CREATE TABLE proxy (
    "directory" varchar(1024),
    "mnt_master" varchar(64) ,
    PRIMARY KEY ("directory", "mnt_master")
);


CREATE TABLE voms_user (
    "subject" varchar(256),
    "name" varchar(64) ,
    PRIMARY KEY ("subject")
);

CREATE TABLE voms_group (
    "subject" varchar(256),
    "name" varchar(64) ,
    PRIMARY KEY ("subject")
);


/* Tables for a file catalogue "guid" VARCHAR(32)*/
CREATE TABLE guids (
  "guid" RAW(16),
  "si" RAW(16),
  "reference" VARCHAR(32),
  "req_delete" RAW(16), 
  "req_migrate" RAW(16),            
  PRIMARY KEY ("guid")
);

CREATE TABLE guids_
(  "guid"  RAW(16)    NOT NULL,
   "si"  RAW(32)  NOT NULL,
   "reference" VARCHAR(32),
   "req_delete" RAW(32),    
   "req_migrate" RAW(32),   
  CONSTRAINT pk_guids PRIMARY KEY ("guid")
) ORGANIZATION INDEX PCTFREE 3;
            

CREATE TABLE replicas (
  "guid" RAW(16) references guids ("guid") ON DELETE CASCADE,
  "last_access" TIMESTAMP,
  "expires" TIMESTAMP,
  "surl" VARCHAR(256),
  PRIMARY KEY ("guid")
);


CREATE TABLE sites (
  "id" INTEGER PRIMARY KEY,
  "name" VARCHAR(64) UNIQUE NOT NULL,
  "hostname" VARCHAR(64),
  "port" INTEGER NOT NULL,
  "login" VARCHAR(32) DEFAULT '',
  "password" VARCHAR(32),
  "use_ssl" SMALLINT DEFAULT 0,
  "authenticate_with_certificate" SMALLINT DEFAULT 0,
  "cert_file" VARCHAR(128),
  "key_file" VARCHAR(128),
  "use_grid_proxy" SMALLINT  DEFAULT 0,
  "verify_server_cert" SMALLINT DEFAULT 0,
  "trusted_cert_dir" VARCHAR(128),
  "require_data_encryption" SMALLINT DEFAULT 0,
  "cert_password" VARCHAR(32)
);

/* Use SHO ERR to debug! */
CREATE OR REPLACE PROCEDURE newguid(tab in varchar, guid in RAW)
AS
BEGIN
  IF NOT guid IS NULL THEN
    INSERT INTO guids ("guid", "si", "reference") VALUES (guid, '', tab);
  END IF;
END;
/

/* Replication: tables used as a slave */
CREATE TABLE masters (
        "mst_id" VARCHAR(64) PRIMARY KEY,
        "mst_active" SMALLINT NOT NULL,
        "mst_last_xid" number(37)
);

CREATE TABLE mounts (
    "mnt_master" VARCHAR(64) REFERENCES masters("mst_id") ON DELETE CASCADE,
    "mnt_directory" VARCHAR(256) PRIMARY KEY,
    "mnt_state" VARCHAR(16) NOT NULL,
    "mnt_rep_permissions" smallint NOT NULL
);


/* Table for holding system information
   - Log tuples is used for counting the number of tuples in the log table
   - rep_users masters and xid keep track of whether the local node is replicating
   user and group information from some other node.
   */
CREATE TABLE amga (
	"amga_version" varchar(8) NOT NULL,
	"amga_node_id" varchar(64),
	"log_table_tuples" INTEGER,
	"rep_users_master" VARCHAR(64) REFERENCES masters("mst_id") ON DELETE SET NULL,
	"rep_users_xid" number(37)
);

INSERT INTO amga ("amga_version", "log_table_tuples", "rep_users_master", "rep_users_xid")
    VALUES ('2.4.0', 0, NULL, NULL);



/* Replication: tables used as a master */
CREATE SEQUENCE logs_seq START WITH 1 INCREMENT BY 1 NOMAXVALUE;

/* log_cwd can be null if the log is for a transaction */
CREATE TABLE logs (
	"log_xid" number(38),
	"log_directory" varchar(256) NOT NULL,
	"log_user" varchar(64) NOT NULL,
	"log_cwd" varchar(256),
	"log_permissions"  char(3) NOT NULL,
	"log_group_rights" char(3) NOT NULL,
	"log_command" CLOB NOT NULL,
	PRIMARY KEY ("log_xid")
);

CREATE TRIGGER logs_insert_trigger BEFORE INSERT ON logs FOR EACH ROW
BEGIN
  SELECT logs_seq.nextval INTO :new."log_xid" FROM dual;
  UPDATE amga SET "log_table_tuples" = "log_table_tuples"+1;
END;
/

CREATE TRIGGER logs_delete_trigger AFTER DELETE ON logs FOR EACH ROW
BEGIN
  UPDATE amga SET "log_table_tuples" = "log_table_tuples"-1;
END;
/

/* The tr_id column gives logs a serial id so they can be ordered*/
CREATE TABLE transactions (
    "tr_id"             NUMBER(38) NOT NULL,
    "tr_transaction_id" number(38) NOT NULL,
    "tr_log_directory"  VARCHAR(256),
    "tr_log_cwd"        VARCHAR(256),
    "tr_log_command"    CLOB NOT NULL,
    CONSTRAINT tr_transaction_id_fk
       FOREIGN KEY ("tr_transaction_id")
       REFERENCES logs("log_xid") ON DELETE CASCADE
);

CREATE INDEX tr_transaction_id_idx ON transactions ("tr_transaction_id");

CREATE SEQUENCE transactions_seq START WITH 1 INCREMENT BY 1 NOMAXVALUE;
CREATE TRIGGER transactions_trigger BEFORE INSERT ON transactions FOR EACH ROW
BEGIN
  SELECT transactions_seq.nextval INTO :new."tr_id" FROM dual;
END;
/

CREATE TABLE subscribers (
	"sub_id" VARCHAR(64) PRIMARY KEY,
	"sub_rep_users" smallint NOT NULL,
	"sub_lease_duration" timestamp,
	"sub_cur_xid" number(37)
);

CREATE TABLE subscriptions (
	"sub_subscriber" VARCHAR(64) REFERENCES subscribers("sub_id") ON DELETE CASCADE,
	"sub_directory" VARCHAR(256),
    "sub_rep_permissions" smallint NOT NULL,
	PRIMARY KEY ("sub_subscriber", "sub_directory")
);



CREATE TABLE constraints (
  "table_id"   integer references masterindex ("id") ON DELETE CASCADE,
  "name"       varchar(64),
  "type"       char(1),
  "column"     varchar(64),
  "constraint" varchar(1024),
    PRIMARY KEY ("table_id", "name")
);

/* For generating unique numbers global to this AMGA installation.*/
CREATE SEQUENCE sequencer START WITH 1 INCREMENT BY 1 NOMAXVALUE;
