# Schema creation for AMGA 2.0
# Table for holding system information
#  Create the initial installation with:
#  mysql -u root
#  
#  create database metadata;
#  use metadata;
#  GRANT ALL PRIVILEGES ON metadata.* TO 'arda'@'localhost';
#  quit
#  mysql -u arda metadata < createInitialMySQL5.sql
#
#  Createing the triggers below also will need SUPER privileges


ALTER DATABASE metadata DEFAULT CHARACTER SET latin1 DEFAULT COLLATE latin1_general_cs;

/* GRANT SUPER ON *.* TO 'arda'@'localhost'; */

CREATE TABLE masterindex (`id` INTEGER unique,
                          `directory` TEXT(1024),
                          `table_name` VARCHAR(64),
                          `flags` SMALLINT,
			  `main_column` VARCHAR(64),
			  `master` VARCHAR(64),
			  `owner_name` VARCHAR(64),
			  `permissions` CHAR(3),
			  `acls` TEXT(2048),
			  `rep_groups` TEXT(2048),
			  `rep_xid` BIGINT,
			  `info` TEXT(2048),
                          PRIMARY KEY(`directory`(256)) 
) ENGINE = InnoDB;

INSERT INTO masterindex (`id`, `directory`, `table_name`, `flags`, `master`, `owner_name`, `permissions`, `acls`, `rep_groups`)
		 VALUES (1, '/', '', x'1000', '', 'root', 'rwx', '|system:anyuser rx|', '');

CREATE TABLE groups (
    `name` VARCHAR(64) PRIMARY KEY,
    `owner` VARCHAR(64),
    `members` TEXT
) ENGINE = InnoDB;

CREATE TABLE users (
    `name` VARCHAR(64) PRIMARY KEY,
    `password` VARCHAR(64),
    `capabilities` VARCHAR(256)
) ENGINE = InnoDB;

CREATE TABLE certificates (
    `subject` TEXT(256),
    `name` VARCHAR(64),
    FOREIGN KEY(`name`) REFERENCES users(`name`) ON DELETE CASCADE,
    PRIMARY KEY (`subject`(256), `name`) 
) ENGINE = InnoDB;

CREATE TABLE proxy (
    `directory` VARCHAR(1024),
    `mnt_master` VARCHAR(64) 
) ENGINE = InnoDB;


CREATE TABLE voms_user (
    `subject` TEXT(256),
    `name` VARCHAR(64), 
    PRIMARY KEY (`subject`(256))
) ENGINE = InnoDB;

CREATE TABLE voms_group (
    `subject` TEXT(256),
    `name` VARCHAR(64), 
    PRIMARY KEY (`subject`(256))
) ENGINE = InnoDB;


/* MySQL emulation for missing sequences */

CREATE TABLE usersequences (
  name CHAR(64) PRIMARY KEY,
  increment INT,
  last_val INT UNSIGNED NOT NULL
);

delimiter //
CREATE FUNCTION seqnextval(myseq varchar(64)) RETURNS BIGINT
READS SQL DATA
BEGIN
    DECLARE val BIGINT;
    UPDATE usersequences SET last_val=last_val+increment WHERE name = myseq;
    SELECT last_val INTO val FROM usersequences WHERE name = myseq FOR UPDATE;
    RETURN val;
END;
//
delimiter ;

/* Tables for a file catalogue */
CREATE TABLE guids (
  `guid` VARCHAR(32),
  `si` VARCHAR(1024),
  `reference` VARCHAR(32),
  `req_delete` VARCHAR(32),
  `req_migrate` VARCHAR(32),
  PRIMARY KEY (`guid`)
) ENGINE = InnoDB;

CREATE TABLE replicas (
  `guid` VARCHAR(32) REFERENCES guids ON DELETE CASCADE,
  `last_access` TIMESTAMP,
  `expires` TIMESTAMP,
  `surl` VARCHAR(256)
) ENGINE = InnoDB;


CREATE TABLE sites (
  `id` INTEGER,
  `name` VARCHAR(64) UNIQUE NOT NULL,
  `hostname` VARCHAR(64) NOT NULL,
  `port` INTEGER NOT NULL,
  `login` VARCHAR(32) NOT NULL DEFAULT '',
  `password` VARCHAR(32),
  `use_ssl` SMALLINT NOT NULL DEFAULT 0,
  `authenticate_with_certificate` SMALLINT NOT NULL DEFAULT 0,
  `cert_file` TEXT(128),
  `key_file` TEXT(128),
  `use_grid_proxy` SMALLINT NOT NULL DEFAULT 0,
  `verify_server_cert` SMALLINT NOT NULL DEFAULT 0,
  `trusted_cert_dir` TEXT(128),
  `require_data_encryption` SMALLINT NOT NULL DEFAULT 0,
  `cert_password` VARCHAR(32),
  PRIMARY KEY(`id`)
) ENGINE = InnoDB;


delimiter //

CREATE PROCEDURE newguid(in tab varchar(64), in guid varchar(33))
BEGIN
    IF NOT guid IS NULL THEN
        INSERT INTO guids (`guid`, `si`, `table_name`) VALUES (guid, '', tab);
    END IF;
END;
//
delimiter ;


/* Replication: tables used as a master */
CREATE TABLE logs (
	`log_xid` SERIAL,
	`log_directory` TEXT(256) NOT NULL,
	`log_user` VARCHAR(64) NOT NULL,
	`log_cwd` TEXT(256),
	`log_permissions` CHAR(3) NOT NULL,
  `log_group_rights` CHAR(3) NOT NULL,
	`log_command` TEXT NOT NULL,
	PRIMARY KEY (`log_xid`)
) ENGINE = InnoDB;


CREATE TABLE sequences (
  `last_log_xid` BIGINT UNSIGNED
) ENGINE = InnoDB;

INSERT INTO sequences(`last_log_xid`) VALUES (0);


CREATE TABLE transactions (
    `tr_id`             SERIAL,
    `tr_transaction_id` BIGINT UNSIGNED,
    `tr_log_directory`  TEXT(256),
    `tr_log_cwd`        TEXT(256),
    `tr_log_command`    TEXT NOT NULL,
    INDEX (`tr_transaction_id`),
    FOREIGN KEY(`tr_transaction_id`) REFERENCES logs(`log_xid`) ON DELETE CASCADE
) ENGINE = InnoDB;


CREATE TABLE subscribers (
    `sub_id` VARCHAR(64) PRIMARY KEY,
    `sub_rep_users` SMALLINT NOT NULL,
    `sub_lease_duration` TIMESTAMP,
    `sub_cur_xid` BIGINT
) ENGINE = InnoDB;

CREATE TABLE subscriptions (
	`sub_subscriber` VARCHAR(64),
	`sub_directory` VARCHAR(256),
	`sub_rep_permissions` SMALLINT NOT NULL,
	PRIMARY KEY (`sub_subscriber`, `sub_directory`),
	FOREIGN KEY (`sub_subscriber`) REFERENCES subscribers(`sub_id`) ON DELETE CASCADE
) ENGINE = InnoDB;

/* Replication: tables used as a slave */

CREATE TABLE masters (
    `mst_id` VARCHAR(64),
    `mst_active`  SMALLINT NOT NULL,
    `mst_last_xid` bigint,
    PRIMARY KEY(`mst_id`(64))
) ENGINE = InnoDB;

CREATE TABLE mounts (
    `mnt_master` VARCHAR(64) REFERENCES masters(`mst_id`) ON DELETE CASCADE,
    `mnt_directory` text(256),
    `mnt_state` VARCHAR(16) NOT NULL,
    `mnt_rep_permissions` SMALLINT NOT NULL,
    PRIMARY KEY(`mnt_directory`(256))
) ENGINE = InnoDB;


/* For generating unique numbers global to this AMGA installation.*/
CREATE TABLE sequencer (
    `id`        BIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE,
    `dummy`     CHAR
) ENGINE = InnoDB;

CREATE TABLE constraints (
  `table_id`   integer,
  `name`       varchar(64),
  `type`       char(1),
  `column`     varchar(64),
  `constraint` TEXT(1024),
    PRIMARY KEY (`table_id`, `name`),
    FOREIGN KEY(`table_id`) REFERENCES masterindex(`id`) ON DELETE CASCADE
) ENGINE = InnoDB;


/* Table for holding system information
   - Log tuples is used for counting the number of tuples in the log table 
   - rep_users masters and xid keep track of whether the local node is replicating
   user and group information from some other node.
   */
CREATE TABLE amga (
	`amga_version` VARCHAR(8) NOT NULL,
	`amga_node_id` VARCHAR(64),
	`log_table_tuples` INTEGER,
	`rep_users_master` VARCHAR(64) REFERENCES masters(`mst_id`) ON DELETE SET NULL,
	`rep_users_xid` BIGINT
) ENGINE = InnoDB;

INSERT INTO amga (`amga_version`, `log_table_tuples`, `rep_users_master`, `rep_users_xid`)
    VALUES ('2.4.0', 0, NULL, NULL);

-- CREATE UPDATE TRIGGER
DELIMITER //
CREATE TRIGGER logsInsert
AFTER INSERT ON logs
FOR EACH ROW BEGIN
    UPDATE amga SET `log_table_tuples` = `log_table_tuples`+1;
    UPDATE sequences SET `last_log_xid` = NEW.log_xid;
END;
//

-- CREATE DELETE TRIGGER
CREATE TRIGGER logsDelete
AFTER DELETE ON logs
FOR EACH ROW BEGIN
    UPDATE amga SET `log_table_tuples` = `log_table_tuples`-1;
END;
//
DELIMITER ;

-- DEBUG: create table debug(p int, grp varchar(2048), pos1 int, pos2 int, grpstart int);
delimiter //
CREATE FUNCTION acl_test(acls varchar(2048), groups varchar(2048), aright varchar(64)) RETURNS int
DETERMINISTIC
BEGIN
    DECLARE grp varchar(256);
    DECLARE pos1 int;
    DECLARE pos2 int;
    DECLARE groupstart int;

    IF acls IS NULL THEN
	RETURN NULL;
    END IF;

    SET pos1 = 1;
    grpLoop: LOOP
        SET grp = NULL;

        SET pos2 = LOCATE(' ', groups, pos1 + 1);
        IF pos2 = 0 THEN
	    SET pos2 = LENGTH(groups) + 1;
        END IF;

	if pos1 = pos2 THEN LEAVE grpLoop;
	END IF;

        SET grp = SUBSTRING(groups, pos1, pos2 - pos1);

--        INSERT INTO debug (p, grp, pos1, pos2, grpstart) VALUES(1, grp, pos1, pos2, NULL);
        
	SET groupstart = LOCATE(CONCAT('|', grp, ' '), acls);
--	INSERT INTO debug (p, grp, pos1, pos2, grpstart) VALUES(3, CONCAT('|', grp, ' '), pos1, pos2, groupstart);
	IF groupstart != 0 THEN
	    SET groupstart = groupstart + LENGTH(grp) + 2;
	    rloop: LOOP
--                INSERT INTO debug (p, grp, pos1, pos2, grpstart) VALUES(2, grp, pos1, pos2, groupstart);

		IF SUBSTRING(acls, groupstart, 1) = '|' THEN LEAVE rloop;
		END IF;
		IF SUBSTRING(acls, groupstart, 1) = aright THEN
		    RETURN 1;
		END IF;
		SET groupstart = groupstart + 1;
	    END LOOP;
	END IF;

        SET pos1 = pos2 + 1;
        IF pos1 >= LENGTH(groups) THEN LEAVE grpLoop;
        END IF;

    END LOOP;
    RETURN NULL;
END;
//
delimiter ;

