/* Table for holding system information *
/*
  Assumes that metadata is the name of the database
  mysql -uroot metadata
  GRANT ALL PRIVILEGES ON metadata.* TO 'arda'@'localhost';

*/

ALTER DATABASE metadata DEFAULT CHARACTER SET latin1 DEFAULT COLLATE latin1_general_cs;

/* GRANT SUPER ON *.* TO 'arda'@'localhost'; */

CREATE TABLE masterindex (`id` INTEGER unique,
                          `directory` TEXT(1024),
                          `table_name` VARCHAR(64),
                          `master` VARCHAR(64),
                          `owner_name` VARCHAR(64),
                          `permissions` CHAR(3),
                          `acls` TEXT(2048),
                          `rep_groups` TEXT(2048),
                          `rep_xid` BIGINT,
                          PRIMARY KEY(`directory`(256)) 
) ENGINE = InnoDB;

INSERT INTO masterindex (`id`, `directory`, `table_name`, `master`, `owner_name`, `permissions`, `acls`, `rep_groups`)
		 VALUES (1, '/', 'x', '', 'root', 'rwx', '|system:anyuser rx|', '');

CREATE TABLE groups (
    `name` VARCHAR(64) PRIMARY KEY,
    `owner` VARCHAR(64),
    `members` text
) ENGINE = InnoDB;

CREATE TABLE users (
    `name` VARCHAR(64) PRIMARY KEY,
    `password` VARCHAR(64),
    `capabilities` VARCHAR(256)    
) ENGINE = InnoDB;

CREATE TABLE certificates (
    `subject` TEXT(256),
    `name` VARCHAR(64),
    FOREIGN KEY(`name`) REFERENCES users(`name`) ON DELETE CASCADE,
    PRIMARY KEY (`subject`(256), `name`) 
) ENGINE = InnoDB;

CREATE TABLE proxy (
    `directory` VARCHAR(1024),
    `mnt_master` VARCHAR(64) 
) ENGINE = InnoDB;

CREATE TABLE voms_user (
    `subject` TEXT(256),
    `name` VARCHAR(64),
    PRIMARY KEY (`subject`(256))
) ENGINE = InnoDB;

CREATE TABLE voms_group (
    `subject` TEXT(256),
    `name` VARCHAR(64),
    PRIMARY KEY (`subject`(256))
) ENGINE = InnoDB;



CREATE TABLE usersequences (
  name CHAR(64) PRIMARY KEY,
  increment INT,
  last_val INT UNSIGNED NOT NULL
);
    

/* Tables for a file catalogue */
CREATE TABLE guids (
  `guid` VARCHAR(32),
  `table_name` VARCHAR(32),
  `si` varchar(1024),
  PRIMARY KEY (`guid`)
) ENGINE = InnoDB;

CREATE TABLE replicas (
  `guid` VARCHAR(32) REFERENCES guids ON DELETE CASCADE,
  `last_access` TIMESTAMP,
  `expires` TIMESTAMP,
  `surl` VARCHAR(256)
) ENGINE = InnoDB;


CREATE TABLE sites (
  `id` INTEGER,
  `name` VARCHAR(64) UNIQUE NOT NULL,
  `hostname` VARCHAR(64) NOT NULL,
  `port` INTEGER NOT NULL,
  `login` VARCHAR(32) NOT NULL DEFAULT '',
  `password` VARCHAR(32),
  `use_ssl` SMALLINT NOT NULL DEFAULT 0,
  `authenticate_with_certificate` SMALLINT NOT NULL DEFAULT 0,
  `cert_file` TEXT(128),
  `key_file` TEXT(128),
  `use_grid_proxy` SMALLINT NOT NULL DEFAULT 0,
  `verify_server_cert` SMALLINT NOT NULL DEFAULT 0,
  `trusted_cert_dir` TEXT(128),
  `require_data_encryption` SMALLINT NOT NULL DEFAULT 0,
  PRIMARY KEY(`id`)
) ENGINE = InnoDB;


CREATE TABLE masters (
    `mst_id` VARCHAR(64),
    `mst_active`  SMALLINT NOT NULL,
    `mst_last_xid` bigint,
    PRIMARY KEY(`mst_id`(64))
) ENGINE = InnoDB;

CREATE TABLE mounts (
    `mnt_master` VARCHAR(64) REFERENCES masters(`mst_id`) ON DELETE CASCADE,
    `mnt_directory` text(256),
    `mnt_state` VARCHAR(16) NOT NULL,
    `mnt_rep_permissions` SMALLINT NOT NULL,
    PRIMARY KEY(`mnt_directory`(256))
) ENGINE = InnoDB;


/* For generating unique numbers global to this AMGA installation.*/
CREATE TABLE sequencer (
    `id`        BIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE,
    `dummy`     CHAR
) ENGINE = InnoDB;

CREATE TABLE constraints (
  `table_id`   integer,
  `name`       varchar(64),
  `type`       char(1),
  `column`     varchar(64),
  `constraint` TEXT(1024),
    PRIMARY KEY (`table_id`, `name`),
    FOREIGN KEY(`table_id`) REFERENCES masterindex(`id`) ON DELETE CASCADE
) ENGINE = InnoDB;


/* Table for holding system information
   - Log tuples is used for counting the number of tuples in the log table 
   - rep_users masters and xid keep track of whether the local node is replicating
   user and group information from some other node.
   */
CREATE TABLE amga (
	`amga_version` VARCHAR(8) NOT NULL,
	`amga_node_id` VARCHAR(64),
	`log_table_tuples` INTEGER,
	`rep_users_master` VARCHAR(64) REFERENCES masters(`mst_id`) ON DELETE SET NULL,
	`rep_users_xid` BIGINT
) ENGINE = InnoDB;

INSERT INTO amga (`amga_version`, `log_table_tuples`, `rep_users_master`, `rep_users_xid`)
    VALUES ('2.4.0', 0, NULL, NULL);
