/*
  Copyright (c) Members of the EGEE Collaboration. 2004. 
  See http://www.eu-egee.org/partners/ for details on the copyright
  holders.  

  Licensed under the Apache License, Version 2.0 (the "License"); 
  you may not use this file except in compliance with the License. 
  You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0 

  Unless required by applicable law or agreed to in writing, software 
  distributed under the License is distributed on an "AS IS" BASIS, 
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
  See the License for the specific language governing permissions and 
  limitations under the License.
*/


#ifndef MD_API_H
#define MD_API_H

// Compatibility with FUSE
#define _FILE_OFFSET_BITS 64

#include <string>
#include <list>
#include <vector>

#include <sys/types.h>
#include <dirent.h>

#define MD_ERR_OK 0
#define MD_ERR_NOENT 1
#define MD_ERR_ILCMD 3
#define MD_ERR_PERM 4
#define MD_ERR_INTERNAL 9
#define MD_ERR_NOKEY 7


class MDClient;

class AttributeList{
 public:
  friend int getAttr(const std::string &pattern,
		     const std::list <std::string > &keys,
		     AttributeList &attributes);
  AttributeList(int columns);
  ~AttributeList();

  int getRow(std::string &file, 
	     std::vector < std::string >  &attributes);
  bool lastRow();

 private:
  void connect(MDClient *c); 
  MDClient *client;
  unsigned int columns;
};


class EntryList{
 public:
  friend int findEntries(const std::string &pattern,
			 const std::string &query,
			 EntryList &entries);
  EntryList();
  ~EntryList();

  int getEntry(std::string &file);
  int cancel();
  bool lastEntry();

 private:
  void connect(MDClient *c);
  MDClient *client;
};


class UploadHandle{
 public:
  friend int upload(const std::string &dir,
		    const std::vector<std::string > &keys,
		    UploadHandle &handle);
  UploadHandle();
  ~UploadHandle();

  int put(const std::string &entry,
	  const std::vector<std::string > &values);

  int abort();
  int commit();

 private:
  void connect(MDClient *c);
  MDClient *client;
};

int translateError(int amga);

int addAttr(const std::string &dir, const std::string &key,
	    const std::string &type="varchar(256)");

int getAttr(const std::string &file, const std::string &key,
	    std::string &attr);

int getAttr(MDClient &client, const std::string &file,
	    const std::string &key, std::string &attr);

int amgaStat(MDClient &client, const std::string &file,
	     struct stat *stbuf);

int amgaReadlink(MDClient &client,
		 const char *path, char *buf, size_t size);

int setAttr(const std::string &file, const std::vector<std::string> &keys,
	    const std::vector<std::string> &values);

int setAttr(MDClient &client, const std::string &file,
	    const std::vector<std::string> &keys,
	    const std::vector<std::string> &values);

int listAttr(MDClient &client,const std::string &file,
	     std::list<std::string> &attrList, 
	     std::list<std::string> &types);

int listAttr(const std::string &file, std::list<std::string> &attrList,
	     std::list<std::string> &types);

int removeAttr(const std::string &file, const std::string &key);

int clearAttr(const std::string &file, const std::string &key);

int createDir(const std::string &dir);

int getAttr(const std::string &pattern,
	    const std::list <std::string > &keys,
	    AttributeList &attributes);

int findEntries(const std::string &pattern,
		const std::string &query,
		EntryList &entries);

int link(const std::string &file, const std::string &URL);


int upload(const std::string &dir,
	   const std::vector<std::string > &keys,
	   UploadHandle &handle);

DIR *amgaOpendir(MDClient &client, const char *name);

struct dirent *amgaReaddir(MDClient &client, DIR *dir);

int amgaClosedir(MDClient &client, DIR *dir);

#endif // MD_API_H
