/*
  Copyright (c) Members of the EGEE Collaboration. 2004. 
  See http://www.eu-egee.org/partners/ for details on the copyright
  holders.  

  Licensed under the Apache License, Version 2.0 (the "License"); 
  you may not use this file except in compliance with the License. 
  You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0 

  Unless required by applicable law or agreed to in writing, software 
  distributed under the License is distributed on an "AS IS" BASIS, 
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
  See the License for the specific language governing permissions and 
  limitations under the License.
*/


// -*- Mode:c++ -*-
// $Id: AMGAService.h,v 1.3 2010/10/26 07:27:47 asunil Exp $
/** Provides AMGA::Service class that describes an AMGA endpoint
**/

#ifndef AMGASERVICE_H
#define AMGASERVICE_H

namespace AMGA {

struct Service {
  Service(const std::string &d, const std::string &h="", int p=0)
    : dn(d), host(h), port(p) {
    // Nothing else...
  }
  std::string dn;
  std::string host;
  int port;
  int status;
  int connection;
};


struct MDChild {
  MDChild(const std::string &d, const std::string &h="", int p=0, void* m = NULL)
    : dn(d), host(h), port(p), mdc(m){
    // Nothing else...
  }
  std::string dn;
  std::string host;
  int port;
  int status;
  int connection;
  void* mdc;
};


}

#endif // AMGASERVICE_H
