/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager.tomcat;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.glite.security.trustmanager.ContextWrapper;

public class TMSSLServerSocketFactory
extends ServerSocketFactory {
    private static final Log LOGGER = LogFactory.getLog(TMSSLServerSocketFactory.class);
    static String defaultAlgorithm = "SunX509";
    protected SSLServerSocketFactory sslProxy = null;
    protected ContextWrapper contextWrapper = null;
    protected String[] enabledCiphers;
    protected boolean requireClientAuth = false;
    protected boolean wantClientAuth = false;
    private boolean m_allowUnsafeLegacyRenegotiation = false;

    public Socket acceptSocket(ServerSocket sSocket) throws IOException {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.acceptSocket:");
        SSLSocket asock = null;
        try {
            asock = (SSLSocket)sSocket.accept();
            this.configureClientAuth(asock);
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
        return asock;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException, InstantiationException {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.createSocket3:");
        if (this.sslProxy == null) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException, InstantiationException {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.createSocket2:");
        if (this.sslProxy == null) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port) throws IOException, InstantiationException {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.createSocket1:");
        if (this.sslProxy == null) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    public void handshake(Socket socket) throws IOException {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.handshake:");
        SSLSession session = ((SSLSocket)socket).getSession();
        if (session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
            throw new IOException("SSL handshake failed. Ciper suite in SSL Session is SSL_NULL_WITH_NULL_NULL");
        }
        if (!this.m_allowUnsafeLegacyRenegotiation) {
            ((SSLSocket)socket).setEnabledCipherSuites(new String[0]);
        }
    }

    void init() throws IOException {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.init:");
        try {
            String trustAlgorithm;
            String keystoreType;
            String algorithm;
            String clientAuthStr = (String)this.attributes.get("clientauth");
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
                this.requireClientAuth = true;
            } else if ("want".equalsIgnoreCase(clientAuthStr)) {
                this.wantClientAuth = true;
            }
            String protocol = (String)this.attributes.get("protocol");
            if (protocol == null) {
                protocol = "TLSv1";
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = defaultAlgorithm;
            }
            if ((keystoreType = (String)this.attributes.get("keystoreType")) == null) {
                keystoreType = "JKS";
            }
            if ((trustAlgorithm = (String)this.attributes.get("truststoreAlgorithm")) == null) {
                trustAlgorithm = algorithm;
            }
            this.initProxy();
            String requestedCiphers = (String)this.attributes.get("ciphers");
            if (requestedCiphers != null) {
                this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, this.sslProxy.getSupportedCipherSuites());
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected String[] getEnabledCiphers(String requestedCiphers, String[] supportedCiphers) {
        LOGGER.debug((Object)("TMSSLServerSocketFactory.getEnabledCiphers: enabling:" + requestedCiphers));
        Object[] acceptedCiphers = null;
        if (requestedCiphers != null) {
            Vector<String> vec = null;
            String cipher = requestedCiphers;
            int index = requestedCiphers.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    cipher = requestedCiphers.substring(fromIndex, index).trim();
                    if (cipher.length() > 0) {
                        for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                            if (!supportedCiphers[i].equals(cipher)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(cipher);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedCiphers.indexOf(44, fromIndex);
                }
                cipher = requestedCiphers.substring(fromIndex);
            }
            if (cipher != null && (cipher = cipher.trim()).length() > 0) {
                for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                    if (!supportedCiphers[i].equals(cipher)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(cipher);
                    break;
                }
            }
            if (vec != null) {
                acceptedCiphers = new String[vec.size()];
                vec.copyInto(acceptedCiphers);
            }
        }
        return acceptedCiphers;
    }

    private void initProxy() throws IOException {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.initProxy:");
        try {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)this.attributes);
            LOGGER.debug((Object)props);
            String crlsEnabled = props.getProperty("crlEnabled", "true");
            if (!crlsEnabled.toLowerCase().startsWith("f") && props.getProperty("crlUpdateInterval") == null) {
                props.setProperty("crlUpdateInterval", "2h");
            }
            this.contextWrapper = new ContextWrapper(props);
            this.sslProxy = this.contextWrapper.getServerSocketFactory();
        }
        catch (Exception e) {
            LOGGER.fatal((Object)("Server socket factory creation failed:  " + e));
            throw new IOException(e.toString());
        }
    }

    private void initServerSocket(ServerSocket ssocket) {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.initServerSocket:");
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        if (this.attributes.get("ciphers") != null) {
            socket.setEnabledCipherSuites(this.enabledCiphers);
        } else {
            String[] ciphers = socket.getEnabledCipherSuites();
            ArrayList<String> newCiphers = new ArrayList<String>(ciphers.length);
            for (int i = 0; i < ciphers.length; ++i) {
                if (ciphers[i].indexOf("RC4") == -1 && ciphers[i].indexOf("ECDH") == -1) {
                    LOGGER.debug((Object)("Enabling cipher: " + ciphers[i]));
                    newCiphers.add(ciphers[i]);
                    continue;
                }
                LOGGER.debug((Object)("Disabling cipher: " + ciphers[i]));
            }
            socket.setEnabledCipherSuites(newCiphers.toArray(new String[0]));
        }
        String requestedProtocols = (String)this.attributes.get("protocols");
        this.setEnabledProtocols(socket, this.getEnabledProtocols(socket, requestedProtocols));
        this.configureClientAuth(socket);
    }

    protected void setEnabledProtocols(SSLServerSocket socket, String[] protocols) {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.setEnabledProtocols:");
        if (protocols != null) {
            socket.setEnabledProtocols(protocols);
        }
    }

    protected String[] getEnabledProtocols(SSLServerSocket socket, String requestedProtocols) {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.getEnabledProtocols:");
        String[] supportedProtocols = socket.getSupportedProtocols();
        Object[] enabledProtocols = null;
        if (requestedProtocols != null) {
            Vector<String> vec = null;
            String protocol = requestedProtocols;
            int index = requestedProtocols.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    protocol = requestedProtocols.substring(fromIndex, index).trim();
                    if (protocol.length() > 0) {
                        for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                            if (!supportedProtocols[i].equals(protocol)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(protocol);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedProtocols.indexOf(44, fromIndex);
                }
                protocol = requestedProtocols.substring(fromIndex);
            }
            if (protocol != null && (protocol = protocol.trim()).length() > 0) {
                for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                    if (!supportedProtocols[i].equals(protocol)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(protocol);
                    break;
                }
            }
            if (vec != null) {
                enabledProtocols = new String[vec.size()];
                vec.copyInto(enabledProtocols);
            }
        }
        return enabledProtocols;
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.configureClientAuth:");
        if (this.wantClientAuth) {
            socket.setWantClientAuth(this.wantClientAuth);
        } else {
            socket.setNeedClientAuth(this.requireClientAuth);
        }
    }

    protected void configureClientAuth(SSLSocket socket) {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.configureClientAuth:");
    }
}

