/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager.tomcat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509KeyManager;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.security.SecurityContext;
import org.glite.security.trustmanager.ContextWrapper;
import org.glite.security.util.CaseInsensitiveProperties;
import org.glite.security.util.DNHandler;

public class TryAuthentication
implements PasswordFinder {
    public char[] getPassword() {
        String password;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            password = reader.readLine();
        }
        catch (IOException e) {
            System.out.println("Error while reading password, error was: " + e.getMessage());
            return null;
        }
        return password.toCharArray();
    }

    public static void main(String[] args) {
        PatternLayout lay = new PatternLayout("%d{ISO8601} %-5p [%t] %c{2} %x - %m%n");
        Logger parent = Logger.getLogger((String)"org.glite.security");
        parent.setLevel(Level.WARN);
        parent.addAppender((Appender)new ConsoleAppender((Layout)lay));
        Logger util = Logger.getLogger((String)"org.glite.security.util");
        util.setLevel(Level.WARN);
        SSLSocket socket = null;
        String server = null;
        String path = null;
        int port = 0;
        if (args.length < 2) {
            System.out.println("Not enought arguments given ");
            System.out.println("Usage: java org.glite.security.trustamanager.tomcat.TestAuthentication server port [path]");
            System.exit(-1);
        } else {
            server = args[0];
            port = Integer.parseInt(args[1]);
            if (args.length >= 3) {
                path = args[2];
            }
        }
        System.out.println("Connecting server " + server + " port " + port + " using SSL");
        CaseInsensitiveProperties props = new CaseInsensitiveProperties(System.getProperties());
        System.out.println("\nThe java environment variables are:");
        System.out.println(props);
        try {
            int i;
            ContextWrapper context = new ContextWrapper((Properties)props);
            X509KeyManager manager = context.getKeyManager();
            String[] aliases = manager.getClientAliases("RSA", null);
            if (aliases == null || aliases.length == 0) {
                System.out.println("\nThe user credentials loading failed");
                System.exit(1);
            }
            java.security.cert.X509Certificate[] chain = manager.getCertificateChain(aliases[0]);
            System.out.println("\nThe user credentials cert chain contains the certificates:");
            for (i = 0; i < chain.length; ++i) {
                System.out.println(DNHandler.getSubject((java.security.cert.X509Certificate)chain[i]));
            }
            try {
                if (context.trustManager != null) {
                    context.trustManager.checkClientTrusted(chain, null);
                } else {
                    context.m_trustmanager.checkClientTrusted(chain, null);
                }
            }
            catch (Exception e) {
                System.out.println("Warning the user credentials would not be accepted in this machine, reason: " + e.getMessage());
                e.printStackTrace(System.out);
            }
            SecurityContext.clearCurrentContext();
            if (context.trustAnchors == null && context.trustManager != null) {
                System.out.println("\nError, no CA certificates could be found from: " + props.getProperty("sslCAFiles", "/etc/grid-security/certificates/*.0"));
            } else if (context.trustAnchors != null) {
                Iterator anchors = context.trustAnchors.iterator();
                System.out.println("\nThe CAs this client accepts are:");
                while (anchors.hasNext()) {
                    System.out.println(((Object)((TrustAnchor)anchors.next()).getTrustedCert().getSubjectDN()).toString());
                }
                if (context.crls == null) {
                    System.out.println("\nWarning, no CRLs could be found from: " + props.getProperty("crlFiles", "undefined"));
                } else {
                    Iterator crls = context.crls.iterator();
                    System.out.println("\nThe CRLs this client is aware of are:");
                    while (crls.hasNext()) {
                        System.out.println(((Object)((TrustAnchor)crls.next()).getTrustedCert().getSubjectDN()).toString());
                    }
                }
            } else if (context.m_trustmanager != null) {
                System.out.println("\nThe CAs this client is aware of are:");
                java.security.cert.X509Certificate[] certs = context.m_trustmanager.getAcceptedIssuers();
                for (int x = 0; x < certs.length; ++x) {
                    System.out.println(x + ": " + certs[x].getSubjectDN());
                }
            }
            SSLSocketFactory sslFactory = context.getSocketFactory();
            System.out.println("\nThe default cipher suites are:");
            String[] suites = sslFactory.getDefaultCipherSuites();
            for (i = 0; i < suites.length; ++i) {
                System.out.println(suites[i]);
            }
            socket = (SSLSocket)sslFactory.createSocket(server, port);
            String[] protocols = socket.getSupportedProtocols();
            System.out.println("\nSupported protocols are:");
            for (i = 0; i < protocols.length; ++i) {
                System.out.println("\n" + protocols[i]);
            }
            protocols = socket.getEnabledProtocols();
            System.out.println("\nEnabled protocols are:");
            for (i = 0; i < protocols.length; ++i) {
                System.out.println("\n" + protocols[i]);
            }
            System.out.println("\nSLLContext protocol is: " + context.getContext().getProtocol());
            socket.startHandshake();
            SSLSession session = socket.getSession();
            System.out.println("\nCipher being used = " + session.getCipherSuite());
            X509Certificate[] serverChain = session.getPeerCertificateChain();
            System.out.println("\nThe server credentials cert chain contains the certificates:");
            for (i = 0; i < serverChain.length; ++i) {
                System.out.println(((Object)serverChain[i].getSubjectDN()).toString());
            }
            SecurityContext sc = SecurityContext.getCurrentContext();
            if (sc == null) {
                System.out.println("\nThe SSL handshake did not proceed to the point of server sending a certificate");
            } else {
                Principal[] principals = sc.getPeerCas();
                if (principals == null) {
                    System.out.println("\nDid not receive any CA names for handshake");
                } else {
                    System.out.println("\nServer accepts certificates signed by:");
                    for (int n = 0; n < principals.length; ++n) {
                        System.out.println(DNHandler.getDN((Principal)principals[n]));
                    }
                }
            }
            System.out.println("\nHandshake succesful");
            TryAuthentication.connectPlain(socket, path);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println("\nSSL handshake failed, reason: " + e.getMessage());
            System.out.println("\nTrying to find more info...");
            try {
                SecurityContext sc = SecurityContext.getCurrentContext();
                if (sc == null) {
                    System.out.println("\nDid SSL handshake did not proceed to the point of server sending a certificate");
                } else {
                    java.security.cert.X509Certificate[] unverifiedChain = sc.getUnverifiedCertChain();
                    if (unverifiedChain == null) {
                        System.out.println("\nDid not receive any cert chain for handshake");
                    } else {
                        System.out.println("\nServer sent cert chain:");
                        for (int n = 0; n < unverifiedChain.length; ++n) {
                            System.out.println(DNHandler.getSubject((java.security.cert.X509Certificate)unverifiedChain[n]));
                        }
                    }
                    Principal[] principals = sc.getPeerCas();
                    if (principals == null) {
                        System.out.println("\nDid not receive any CA names for handshake");
                    } else {
                        System.out.println("\nServer accepts certificates signed by:");
                        for (int n = 0; n < principals.length; ++n) {
                            System.out.println(DNHandler.getDN((Principal)principals[n]));
                        }
                    }
                }
                SSLSession session = socket.getSession();
                System.out.println("\nCipher being used = " + session.getCipherSuite());
                X509Certificate[] serverChain = session.getPeerCertificateChain();
                System.out.println("\nThe server credentials cert chain contains the certificates:");
                for (int i = 0; i < serverChain.length; ++i) {
                    System.out.println(((Object)serverChain[i].getSubjectDN()).toString());
                }
            }
            catch (Exception e2) {
                System.out.println("\nInfo finding failed, reason: " + e2.getMessage());
                e2.printStackTrace(System.out);
            }
            System.exit(1);
        }
    }

    static boolean connectPlain(SSLSocket socket, String path) throws IOException {
        try {
            OutputStream out = socket.getOutputStream();
            String host = socket.getInetAddress().getCanonicalHostName();
            SSLSession session = socket.getSession();
            Certificate[] array = session.getPeerCertificates();
            List<Certificate> list = Arrays.asList(array);
            ListIterator<Certificate> iter = list.listIterator();
            while (iter.hasNext()) {
                System.out.println("server cert chain is " + iter.next());
            }
            System.out.println("Host: " + host);
            if (path != null) {
                out.write(("GET " + path + " HTTP/1.1\n").getBytes());
            } else {
                out.write("GET /index.html HTTP/1.1\n".getBytes());
            }
            out.write(("Host: " + host + "\n\n").getBytes());
            out.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String buf = in.readLine();
            while (buf != null) {
                System.out.println("> " + buf);
                if (!in.ready()) break;
                buf = in.readLine();
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            throw e;
        }
        System.out.println("Success");
        return true;
    }
}

