/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager.axis;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import org.glite.security.SecurityInfo;
import org.glite.security.SecurityInfoContainer;
import org.glite.security.trustmanager.axis.EchoService;
import org.glite.security.util.CertUtil;
import org.glite.security.util.DNHandler;
import org.glite.security.util.axis.InitSecurityContext;

public class EchoServiceSoapBindingImpl
implements EchoService {
    public String getAttributes() throws RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append("EchoSecurityService\n\n");
        buf.append("Hello, this is the EchoService web service.\n");
        buf.append("This web service prints out all the security related info available from the client.\n");
        try {
            InitSecurityContext.init();
            SecurityInfo secInfo = SecurityInfoContainer.getSecurityInfo();
            X509Certificate[] cert = secInfo.getClientCertChain();
            buf.append("You're connecting from: " + secInfo.getRemoteAddr() + "\n");
            buf.append("The session ID for this connection is: " + secInfo.getSessionId() + "\n");
            buf.append("Your DN is: " + secInfo.getClientName() + "\n");
            buf.append("Issued by: " + secInfo.getIssuerName() + "\n");
            buf.append("You authenticated with a certificate " + DNHandler.getSubject((X509Certificate)secInfo.getClientCertChain()[0]).getRFC2253() + "\n");
            buf.append("Your final certificate subject is: " + DNHandler.getSubject((X509Certificate)cert[0]) + "\n");
            buf.append("You end entity identity is: " + CertUtil.getUserDN((X509Certificate[])secInfo.getClientCertChain()).getRFCDN());
            boolean proxy = false;
            try {
                DNHandler.getSubject((X509Certificate)cert[0]).withoutLastCN(true);
                proxy = true;
            }
            catch (Exception e) {
                proxy = false;
            }
            buf.append("Your end cert is: " + (proxy ? "proxy certificate" : "end-user certificate") + "\n\n");
            buf.append("Your cert is: \n");
            buf.append(secInfo.getClientCert().toString());
        }
        catch (Exception e) {
            buf.append("Error while handling the certificate chain:\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            e.printStackTrace();
            buf.append(sw.toString());
            throw new RemoteException(buf.toString());
        }
        buf.append("\nFinished\n");
        return buf.toString();
    }
}

