/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.axis;

import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import org.apache.axis.InternalException;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.glite.security.SecurityContext;

public class InitSecurityContext {
    protected static Logger log = Logger.getLogger(InitSecurityContext.class);

    public static void init() {
        MessageContext messageContext = MessageContext.getCurrentContext();
        if (messageContext == null) {
            throw new InternalException("No MessageContext found, method probably not called inside a web service");
        }
        ServletRequest req = (ServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (req == null) {
            log.warn((Object)"SOAP Authorization: MC_HTTP_SERVLETREQUEST is null");
            InitSecurityContext.initClearSC();
        } else {
            InitSecurityContext.initSC(req);
        }
    }

    public static void initSC(ServletRequest req) {
        log.debug((Object)"Creating a new security context");
        SecurityContext sc = new SecurityContext();
        SecurityContext.setCurrentContext((SecurityContext)sc);
        try {
            X509Certificate[] cert = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
            sc.setClientCertChain(cert);
            String remote = req.getRemoteAddr();
            sc.setRemoteAddr(remote);
            req.getAttribute("javax.servlet.request.key_size");
            String sslId = (String)req.getAttribute("javax.servlet.request.ssl_session");
            sc.setSessionId(sslId);
            log.info((Object)("Connection from \"" + remote + "\" by " + sc.getClientDN()));
        }
        catch (Exception e) {
            log.warn((Object)("Exception during certificate chain retrieval: " + e));
        }
    }

    public static void initClearSC() {
        log.info((Object)"Clearing the security context");
        SecurityContext sc = new SecurityContext();
        SecurityContext.setCurrentContext((SecurityContext)sc);
    }
}

