/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.util;

import eu.emi.emir.client.util.Log;
import eu.emi.emir.core.RegistryThreadPool;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class TimeoutRunner<V>
implements Callable<V> {
    private static final Logger logger = Log.getLogger((String)"emir.core", TimeoutRunner.class);
    private final Callable<V> task;
    private V result;
    private final int timeout;
    private final TimeUnit unit;

    public TimeoutRunner(Callable<V> task, int timeout, TimeUnit unit) {
        this.task = task;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public V call() throws RejectedExecutionException, InterruptedException {
        logger.debug((Object)("Starting task with timeout of " + this.timeout + " " + (Object)((Object)this.unit)));
        try {
            Future<V> res = RegistryThreadPool.getExecutorService().submit(this.task);
            this.result = res.get(this.timeout, this.unit);
        }
        catch (TimeoutException ignored) {
            logger.debug((Object)"Timeout reached!");
        }
        catch (Exception ex) {
            Log.logException((String)"Error waiting for task to complete", (Throwable)ex, (Logger)logger);
        }
        return this.result;
    }

    public static <Result> Result compute(Callable<Result> task, int timeout) {
        TimeoutRunner<Result> runner = new TimeoutRunner<Result>(task, timeout, TimeUnit.MILLISECONDS);
        try {
            return runner.call();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <Result> Result compute(Callable<Result> task, int timeout, TimeUnit units) {
        TimeoutRunner<Result> runner = new TimeoutRunner<Result>(task, timeout, units);
        try {
            return runner.call();
        }
        catch (Exception e) {
            return null;
        }
    }
}

