/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FileWatcher
implements Runnable {
    private final Set<File> targets = new HashSet<File>();
    private final Runnable action;
    private long lastAccessed = System.currentTimeMillis();

    public FileWatcher(File target, Runnable action) throws FileNotFoundException {
        if (!target.exists() || !target.canRead()) {
            throw new FileNotFoundException("File " + target.getAbsolutePath() + " does not exist or is not readable.");
        }
        this.action = action;
        this.addTarget(target);
    }

    public void schedule(int delay, TimeUnit timeunit) {
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(this, delay, delay, timeunit);
    }

    public void addTarget(File target) {
        this.targets.add(target);
    }

    public boolean removeTarget(File target) {
        return this.targets.remove(target);
    }

    @Override
    public void run() {
        for (File target : this.targets) {
            if (!target.exists() || target.lastModified() < this.lastAccessed) continue;
            this.lastAccessed = System.currentTimeMillis();
            this.action.run();
            break;
        }
    }
}

